import { SHARED_MESSAGES } from '../../../workers/chat-shared.worker';
import { generateuuid4 } from '../utils';

interface IBackgroundTabsProps {
    onMessage?: Function;
    onSlave?: Function;
    onMaster?: Function;
}

export class BackgroundTabs {
    protected _uuid: string | null = null;
    shared: any = new SharedWorker(
        new URL('./../../../workers/chat-shared.worker', import.meta.url) as unknown as string,
    );
    _onMessage;
    _onSlave;
    _onMaster;
    _idTitle = 'tab_uuid';

    constructor(props?: IBackgroundTabsProps) {
        this._onMessage = props?.onMessage;
        this._onSlave = props?.onSlave;
        this._onMaster = props?.onMaster;

        if (!sessionStorage.getItem(this._idTitle)) {
            this._uuid = generateuuid4();
            sessionStorage.setItem(this._idTitle, this._uuid);
        } else {
            this._uuid = sessionStorage.getItem(this._idTitle);
        }

        window.addEventListener('beforeunload', () => {
            this.shared.port.postMessage({ message: SHARED_MESSAGES.finish, id: this._uuid });
        });

        window.addEventListener(SHARED_MESSAGES.focus, () => {
            this.shared.port.postMessage({ message: SHARED_MESSAGES.focus, id: this._uuid });
        });

        if (!document.hidden) {
            this.shared.port.postMessage({ message: SHARED_MESSAGES.init, id: this._uuid, active: true });
            this._onMaster();
        } else {
            this.shared.port.postMessage({ message: SHARED_MESSAGES.init, id: this._uuid, active: false });
            this._onSlave();
        }

        this._initListeners();
    }

    protected _initListeners() {
        this.shared.port.start();
        this.shared.port.postMessage({ message: 'start', id: this._uuid });

        this.shared.port.addEventListener('message', (e) => {
            if (e.data.message === SHARED_MESSAGES.focused) {
                if (e.data.id !== this._uuid) {
                    this._onSlave(e);
                } else {
                    this._onMaster(e);
                }
            }
        });
    }
}
