import * as React from 'react';

import { MenuItem } from '../components/LeftMenu/MenuItem';
import { IRuleState } from '../reducers/adminUserReducer';
import { checkRouteByRules } from './checkRouteByRules';
import { NAVIGATION } from './navigation';
import { Translate } from './translate';

interface ILeftMenuItemsProps {
    rules: IRuleState;
    toggleMenu: (state: boolean) => void;
    t: Translate;
    filterValue: string;
    resetFilterValue: () => void;
}

export const CreateLeftMenuItems = (props: ILeftMenuItemsProps) => {
    const { rules, toggleMenu, t, filterValue, resetFilterValue } = props;
    const menuItems = Object.entries(NAVIGATION.ROUTES)
        .sort((a, b) => {
            return a[1].order - b[1].order;
        });

    return (
        <>
            {
                menuItems.map((menu, index) => {
                    const withId = !!menu[1].id;
                    const withExtraId: boolean = menu[1].withExtraId || false;
                    const checkRoutes = checkRouteByRules({ rules, uri: menu[1].uri, route: menu });

                    return checkRoutes.show && (!withId || withExtraId)
                        ? <MenuItem key={index}
                                    href={`#/${menu[1].uri}`}
                                    uri={menu[1].uri}
                                    tabs={withExtraId ? [] : checkRoutes.tabs}
                                    t={t}
                                    filterValue={filterValue}
                                    toggleMenu={toggleMenu}
                                    resetFilterValue={resetFilterValue}/>
                        : null;
                })
            }
        </>
    );
};
