import React from 'react';

import { SensorHistoryModal } from '../../components/CarCard/CarTelematics/component';
import Spin from '../../components/Spin';
import { Window } from '../../ui/FullModal';
import { Request2 } from '../request';
import { CAR_REQUESTS as requestConfigs, REQUESTS } from './requests';

interface ICarFuelModalModalProps {
    onClose: (isOpened?: boolean) => void;
    carId: string;
    imei: string;
}

interface ICarFuelModalModalState {
    isLoading: boolean;
    currentState: ICurrentCarState | null;
    error: Error | null;
}

interface ICurrentCarState {
    name: string;
    id: number;
    since: number;
    updated: number;
    value: number;
}

export class CarFuelModal extends React.Component<ICarFuelModalModalProps, ICarFuelModalModalState> {
    state: ICarFuelModalModalState = {
        isLoading: false,
        currentState: null,
        error: null,
    };

    request = new Request2({ requestConfigs });

    componentDidMount() {
        this.getCarState();
    }

    getCarState() {
        const { carId } = this.props;

        this.setState({
            isLoading: true,
            error: null,
        }, () => {
            this.request.exec(REQUESTS.GET_TELEMATICS_STATE, {
                queryParams: {
                    car_id: carId,
                },
            })
                .then(response => {
                    const currentState = response.sensors?.find(el => el.name === 'fuel_level');
                    this.setState({ currentState });
                })
                .catch(error => {
                    this.setState({
                        error,
                        isLoading: false,
                    });
                });
        });
    }

    render() {
        const { onClose, imei } = this.props;
        const { isLoading, error, currentState } = this.state;

        return currentState
            ? <SensorHistoryModal sensor={currentState} onClose={onClose.bind(this, false)} imei={imei}/>
            : error || isLoading
                ? <Window onClose={onClose.bind(this, false)}
                          error={error}
                          title={'История сенсора fuel_level'}>
                    {isLoading ? <Spin/> : null}
                </Window>
                : null;
    }
}
