import { IRuleState } from '../reducers/adminUserReducer';
import { INavigationRouteItem } from './navigation';

interface ICheckRouteByRulesParameters {
    rules: IRuleState;
    uri: string;
    route: [string, INavigationRouteItem];
}

interface checkedRoutes {
    show: boolean;
    tabs: INavigationRouteItem[];
}

const checkUri = (rules: IRuleState, uri: string) => {
    return rules[uri]
        || Object.keys(rules).some(rule => {
            const _rules = `^${rule.split('*').join('[\\w, -]*')}$`;
            const reg = new RegExp(_rules, 'ig');

            return reg.test(uri) && rules[rule];
        });
};

export const checkRouteByRules = ({ rules, uri, route }: ICheckRouteByRulesParameters): checkedRoutes => {
    const result: checkedRoutes = { show: false, tabs: [] };
    if (route && route[1] && route[1].tabs && Array.isArray(route[1].tabs) && route[1].tabs.length) {
        result.tabs = route[1].tabs.filter(tab => {
            const tabUri = `${uri}/${tab.uri}`;

            return checkUri(rules, tabUri);
        }) || [];

        if (result.tabs && result.tabs.length) {
            result.show = true;
        }
    } else {
        result.show = checkUri(rules, uri);
    }

    return result;
};
