import * as React from 'react';

import { ErrorSource, logError } from '../../components/Content/initErrorCounter';
import { ChunksErrorView } from '../../components/GlobalErrorCatchHandler';

type TLazyImport = { default: React.ComponentType<any> };
export const chunksErrorHandling = async (fn: () => Promise<TLazyImport>): Promise<TLazyImport> => {
    try {
        return await fn();
    } catch (e) {
        return new Promise((resolve) => {
            logError(e, ErrorSource.POSSIBLE_CHUNK_ERROR);

            return resolve({
                default: ChunksErrorView.bind(null, e),
            });
        });
    }
};
