import React from 'react';
import { Redirect, Route, Switch } from 'react-router';

import styles from '../components/Content/index.css';
import { ErrorSource, logError } from '../components/Content/initErrorCounter';
import { ErrorView } from '../components/GlobalErrorCatchHandler';
import Spin from '../components/Spin';
import { IRuleState } from '../reducers/adminUserReducer';
import { checkRouteByRules } from './checkRouteByRules';
import { getTabName } from './getTabName';
import { INavigationRouteItem, NAVIGATION } from './navigation';
import { ytLogs } from './sendLogs';
import { EVENT_TYPES } from './sendLogs/eventTypes/eventTypes';
import { Translate } from './translate';

export const createRoutes = (rules: IRuleState, t: Translate) => {
    const log = ytLogs.getInstance();

    return Object.entries(NAVIGATION.ROUTES)
        .map((route, index) => {
            const Component = route[1].ui;
            const path = route[1].id ? `/${route[1].uri}/:${route[1].id}?/:tabId?` : `/${route[1].uri}/:tabId?`;

            return <Route path={path}
                          key={index}
                          render={(props) => {
                              const tabName = getTabName(props.location.pathname);
                              const uri = route[1].id ? `/${route[1].uri}/${route[1].id}` : route[1].uri;

                              const checkRoutes = checkRouteByRules({ rules, uri: route[1].uri, route });
                              if (route[1].id) {
                                  const content = <WrapOnlyTabsContentComponent {...props}>
                                      <Switch>
                                          {
                                              checkRoutes.tabs
                                    && checkRoutes.tabs.map((subRoute: INavigationRouteItem) => {
                                        const path = route[1].id
                                            ? `/${route[1].uri}/:${route[1].id}/${subRoute.uri}`
                                            : `/${route[1].uri}/${subRoute.uri}`;

                                        return subRoute.ui
                                            && <Route key={subRoute.uri}
                                                      path={path}
                                                      render={(props) => {
                                                          return <subRoute.ui {...props} text={subRoute.uri}/>;
                                                      }
                                                      }/>;
                                    })
                                          }
                                          <Route render={(props) => {
                                              if (props.match.params.tabId) {
                                                  return <Redirect to={{
                                                      pathname: '/',
                                                      search: `?redirect=${props.location.pathname}`,
                                                  }}/>;
                                              }

                                              return null;
                                          }}/>
                                      </Switch>
                                  </WrapOnlyTabsContentComponent>;

                                  if (checkRoutes.show) {
                                      if (tabName.length) {
                                          log.send({
                                              data: {
                                                  event_type: EVENT_TYPES.SHOW_TAB,
                                                  tab_name: tabName,
                                                  target_object_id: props.match.params.client_id
                                            || props.match.params.car_id
                                            || props.match.params.session_id,
                                              },
                                          });
                                      }

                                      return <React.Suspense fallback={<Spin/>}>
                                          <div className={styles.cardNavigationContainer}>
                                              <Component {...props}
                                                         uri={uri}
                                                         title={route[1].uri}
                                                         tabs={checkRoutes.tabs}
                                                         t={t}>
                                                  <React.Suspense fallback={<Spin/>}>
                                                      {content}
                                                  </React.Suspense>
                                              </Component>
                                          </div>
                                      </React.Suspense>;
                                  }

                                  return <Redirect to={{ pathname: '/', search: `?redirect=${route[1].uri}` }}/>;

                              }

                              if (checkRoutes.show) {
                                  if (tabName.length) {
                                      log.send({
                                          data: {
                                              event_type: EVENT_TYPES.SHOW_TAB,
                                              tab_name: tabName,
                                          },
                                      });
                                  }

                                  return (
                                      <React.Suspense fallback={<Spin/>}>
                                          <Component {...props}
                                                     uri={uri}
                                                     title={route[1].uri}
                                                     tabs={checkRoutes.tabs}
                                                     t={t}/>
                                          <React.Suspense fallback={<Spin/>}>
                                              <WrapOnlyTabsContentComponent {...props}>
                                                  <Switch>
                                                      {
                                                          checkRoutes.tabs
                                                    && checkRoutes.tabs.map((subRoute: INavigationRouteItem) => {
                                                        const path = route[1].id
                                                            ? `/${route[1].uri}/:${route[1].id}/${subRoute.uri}`
                                                            : `/${route[1].uri}/${subRoute.uri}`;

                                                        return subRoute.ui
                                                            && <Route key={subRoute.uri}
                                                                      path={path}
                                                                      render={(props) => {
                                                                          return <subRoute.ui {...props}
                                                                                              text={subRoute.uri}/>;
                                                                      }
                                                                      }/>;
                                                    })
                                                      }
                                                      <Route render={(props) => {
                                                          if (props.match.params.tabId) {
                                                              return <Redirect to={{
                                                                  pathname: '/',
                                                                  search: `?redirect=${props.location.pathname}`,
                                                              }}/>;
                                                          }

                                                          return null;
                                                      }}/>
                                                  </Switch>
                                              </WrapOnlyTabsContentComponent>
                                          </React.Suspense>
                                      </React.Suspense>
                                  );
                              }

                              return <Redirect to={{ pathname: '/', search: `?redirect=${route[1].uri}` }}/>;

                          }}/>;
        });
};

class WrapOnlyTabsContentComponent extends React.Component<any, any> {
    state = {
        error: null,
    };

    UNSAFE_componentWillReceiveProps(nextProps: any, nextContext: any): void {
        if (nextProps.location !== this.props.location) {
            this.setState({ error: null });
        }
    }

    componentDidCatch(error: Error, errorInfo: React.ErrorInfo): void {
        logError(error, ErrorSource.ERROR_BOUNDARY, errorInfo);
        this.setState({ error });
    }

    render() {
        return !this.state.error ? this.props.children : <ErrorView error={this.state.error}/>;
    }
}
