import { Dict, LSSettingItems, ValueOf } from '../../../types';
import LS from '../localStorage/localStorage';
import { CS_DEFAULT_SETTINGS } from './defaults';

export enum CSSettingsItems {
    walletsExpanded = 'walletsExpanded',
    cardsExpanded = 'cardsExpanded',
    showPolyTrack = 'showPolyTrack',
    showAllTrack = 'showAllTrack',
    showFixTrack = 'showFixTrack',
    showWelcomes = 'showWelcomes',
    useHotkeys = 'useHotkeys',
    userBalanceExpanded = 'userBalanceExpanded',
    disableFeedRequests = 'disableFeedRequests',
    nightMode = 'nightMode',
    shouldNeverShowWebphoneWelcomePopup = 'shouldNeverShowWebphoneWelcomePopup',
    showUserNameInMessages = 'showUserNameInMessages',
    allowSaveCarsFilters = 'allowSaveCarsFilters',
    lastShowNDAWarning = 'lastShowNDAWarning',
}

export interface CSSettingsTypes {
    walletsExpanded: boolean;
    cardsExpanded: boolean;
    showPolyTrack: boolean;
    showAllTrack: boolean;
    showFixTrack: boolean;
    showWelcomes: boolean;
    useHotkeys: boolean;
    userBalanceExpanded: boolean;
    disableFeedRequests: boolean;
    nightMode: boolean;
    shouldNeverShowWebphoneWelcomePopup: boolean;
    showUserNameInMessages: boolean;
    allowSaveCarsFilters: boolean;
    lastShowNDAWarning: number | null;
}

export class CustomSettings {
    ls = new LS();

    getSettings(): Dict<boolean> | null {
        const data = this.ls.get(LSSettingItems.customSettings) ?? null;
        const dataKeys = Object.keys(data);
        const defaultKeys = Object.keys(CS_DEFAULT_SETTINGS);

        if (dataKeys.length !== defaultKeys.length) {
            this.reset(data);
        } else {
            dataKeys.sort();
            defaultKeys.sort();

            if (!defaultKeys.every((key, index) => dataKeys[index] === key)) {
                this.reset(data);
            }
        }

        return data;
    }

    init() {
        this.getSettings();
    }

    set(field: CSSettingsItems, value: ValueOf<CSSettingsTypes>) {
        const data: any = this.getSettings();
        data[field] = value;

        this.ls.set(LSSettingItems.customSettings, data);

        return data;
    }

    get(field: CSSettingsItems) {
        let data: any = this.getSettings();
        if (!data) {
            data = null;
            console.warn(`CustomSettings: data is empty`);
        }

        if (data.hasOwnProperty(field)) {
            data = data[field];
        } else {
            data = null;
            console.warn(`CustomSettings: setting doesn\'t exist'.\n\r`);
        }

        return data;
    }

    private reset(data) {
        this.ls.set(LSSettingItems.customSettings, { ...CS_DEFAULT_SETTINGS, ...data });
    }
}
