import { store } from '../components/App/store';
import { setConstants } from '../reducers/constantsReducer';
import { IComponentRequest, Request2, specialQueryParamsKeys } from './request';

const REQUESTS: { [key: string]: string } = {
    GET_CONSTANTS: 'GET_CONSTANTS',
};

const CONSTANTS_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_CONSTANTS]: {
        api: 'constants',
        cgiObj: {
            traits: null,
            /*  old_behaviour: null,*/
            ids: null,
        },
    },
};

// [key]: constants?traits={value}
const ConstantsTraits = {
    action_types: 'action_types',
    billing: 'accounts',
    car_actions: '',
    documents_manager: 'documents',
    iface_tag_filters: 'tag_filters',
    tag_types: 'tag_types',
    iface: 'actions',
    iface_rt_background_settings: 'rt_background',
    iface_rt_background_state: 'rt_background',
    iface_tag_implementations: 'tags',
    iface_notifiers: 'notifiers',
    iface_tag_descriptions: 'tag_descriptions',
};

export enum ConstantsKey {
    ACTION_TYPES = 'action_types',
    BILLING = 'billing',
    CAR_ACTIONS = 'car_actions',
    DOCUMENTS_MANAGER = 'documents_manager',
    IFACE_TAG_FILTERS = 'iface_tag_filters',
    TAG_TYPES = 'tag_types',
    IFACE = 'iface',
    IFACE_RT_BACKGROUND_SETTINGS = 'iface_rt_background_settings',
    IFACE_RT_BACKGROUND_STATE = 'iface_rt_background_state',
    IFACE_TAG_IMPLEMENTATIONS = 'iface_tag_implementations',
    IFACE_NOTIFIERS = 'iface_notifiers',
    IFACE_TAG_DESCRIPTIONS = 'iface_tag_descriptions',
}

export const fetchConstants = async (
    keys: ConstantsKey[] | string[],
    dispatch,
    force = false,
    ids?: string,
): Promise<any> => {
    const reduxConstants = store.getState().Constants;

    const constants = {};
    let traits: Set<string> | null = new Set<string>();

    keys.forEach((key) => {
        if (!reduxConstants[key] || force || ids) { //всегда ходим в ручку, если есть force или ids
            if ((ConstantsTraits[key] || key) && traits) {
                traits.add(ConstantsTraits[key] || key);
            } else {
                traits = null;
            }
        }
    });

    let response: any = {};
    let resultStore = {
        ...reduxConstants,
    };

    if ((traits && traits.size > 0) || traits === null || force || ids) {
        const request = new Request2({ requestConfigs: CONSTANTS_REQUESTS });

        const options: any = {
            queryParams: {
                traits: traits ? [...traits].join(',') : traits,
                ...ids && { ids },
            },
            specialQueryParams: {
                old_behaviour: {
                    value: false,
                    key: specialQueryParamsKeys.FORCE,
                },
            },
        };

        try {
            response = await request.exec(REQUESTS.GET_CONSTANTS, ...options);
        } catch (err) {
            return Promise.reject(err);
        }

        resultStore = {
            ...resultStore,
            ...response,
        };

        dispatch(setConstants(resultStore, null));
    }

    keys.forEach((key) => {
        constants[key] = resultStore[key];
    });

    return new Promise((resolve) => {
        resolve(constants);
    });
};
