import { NChats } from '../components/ChatsCommon/types';
import ITree = NChats.ITree;
import { ONE_SECOND } from '../constants';

export type IFormatHandlers = IFormatHandler<string> | IFormatHandler<number>;

export type IFormatHandler<T> = (value: T) => string;

export interface IFormatter {
    space: IFormatHandler<string>;
    date: IFormatHandler<number>;
}

const Formatter: IFormatter = {
    space: value => value?.replace(/\s/ig, ''),
    date: value => new Date(value * ONE_SECOND).toLocaleString(),
};

export default Formatter;

const format = (data) => {
    const tag_descriptions = data.tag_descriptions.reduce((_p: any, _c: any) => {
        return {
            ..._p,
            [_c.name]: _c.display_name,
        };
    }, {});

    const queue = data.results && data.results[0]
        && data.results[0].report
        && data.results[0].report.reduce((_p: any, _c: any) => {
            const temp = _c.tags && Array.isArray(_c.tags) && _c.tags.map(el => {
                return {
                    user_id: el.object_id,
                    chat_id: el.topic_link,
                    tag_id: el.tag_id,
                    tag: el.tag,
                    tag_display_name: tag_descriptions[el.tag],
                    performer: el.performer,
                };
            });

            return [..._p, ...temp];
        }, []);
    const tree: ITree = queue.reduce((_p: ITree, _c) => {
        if (!_p.hasOwnProperty(_c.tag)) {
            _p[_c.tag] = [_c];
        } else {
            _p[_c.tag].push(_c);
        }

        return _p;
    }, {});

    return { queue, tree };
};

export const chatArchiveFormat = (data) => {
    const queue = data.tags && data.tags.map(tag => {
        return { user_id: tag.object_id, chat_id: tag.tag_details && tag.tag_details.topic_link };
    }) || [];
    const tree = {};

    return { queue, tree };
};

export { format as tagsFormatToChats };
