const LOCALHOST_ORIGIN = ['https://localhost.yandex-team.ru:9000',
    'https://localhost.n.yandex-team.ru:9000'];

const DEVELOPMENT_ORIGIN = [
    ...LOCALHOST_ORIGIN,
    'stand.carsharing.yandex-team.ru',
    'https://testing.carsharing.yandex-team.ru',
    'https://prestable.carsharing.yandex-team.ru',
];

export const isDevOrigin = () => {
    return process.env.DISABLE_ORIGIN_CHECK !== 'true'
        ? DEVELOPMENT_ORIGIN.some((origin) => location.origin.includes(origin))
        : false;
};

export const isLocalhost = () => {
    return process.env.DISABLE_ORIGIN_CHECK !== 'true'
        ? LOCALHOST_ORIGIN.some((origin) => location.origin.includes(origin))
        : false;
};
