export interface ILongtermFeedTag {
    comment: string;
    display_name: string;
    linked_tag_id: string;
    links: string[];
    object_id: string;
    original_support_line: string;
    priority: number;
    tag: 'support_out_longterm';
    tag_id: string;
    topic_link: string;
}

export function getLongtermFeedLink(longtermFeedTag: ILongtermFeedTag) {
    if (longtermFeedTag) {
        const { object_id, topic_link, tag_id } = longtermFeedTag;

        return `#/outgoing?user_id=${object_id}&chat_id=${topic_link}&tag_id=${tag_id}`;
    }

    return '';

}
