import React from 'react';

import { Button, ButtonTypes } from '../../ui/Button';
import { Link } from '../../ui/Link';
import { getLongtermFeedLink, ILongtermFeedTag } from './getLongtermFeedLink';

interface ILongtermFeedButtonProps {
    tag: ILongtermFeedTag;
    isLoading?: boolean;
    error?: Error | null;
    className?: string;
}

export const LongtermFeedButton = React.memo((props: ILongtermFeedButtonProps) => {
    const { tag, isLoading, error, className = '' } = props;
    const href = getLongtermFeedLink(tag);
    const isDisabled = Boolean(!href || error);

    return <Link href={href} disable={isDisabled} className={className} target={'_blank'}>
        <Button basic={true} colorType={ButtonTypes.positive} isLoading={isLoading} disabled={isDisabled}>
            Лента долгосрока
        </Button>
    </Link>;
});
