import { createSelector } from 'reselect';

import { IStore } from '../../components/App/store';
import { isValidJSONString } from '../isValidJSONString';

export function getRawSetting(store: IStore, settingKey: string) {
    const settingStr = store?.AdminUser?.rawSettings
        ?.find((setting) => setting.setting_key === settingKey)?.setting_value;

    return isValidJSONString(settingStr) ? JSON.parse(settingStr) : settingStr;
}

const getRawSettingSelect = (store, settingKey) => {
    return store?.AdminUser?.rawSettings?.find((setting) => setting.setting_key === settingKey)?.setting_value;
};

export const getRawSetting2 = createSelector(getRawSettingSelect, (rawSettings) => {
    return isValidJSONString(rawSettings) ? JSON.parse(rawSettings) : rawSettings;
});
