import { isValidSessionId } from '../isValidSessionId';
import { NAVIGATION } from '../navigation';
import { isValidGUIDString } from '../utils';

const PATHNAME_THIRD_PART = 2;
const PATHNAME_NOSUBID_LENGTH = 2;
const PATHNAME_SUBID_LENGTH = 3;

export const getTabName = (pathname) => {
    let tabName = '';

    if (pathname === '/') {
        return '/';
    }

    if (pathname) {
        const pathnameParts = pathname?.split('/')?.slice(1);
        let withId = false;
        let hasTabs = false;
        const hasIdInPathname = pathnameParts?.[1]
            && isValidGUIDString(pathnameParts?.[1])
            || isValidSessionId(pathnameParts?.[1]);

        Object.entries(NAVIGATION.ROUTES)
            .forEach((menu) => {
                if (menu[1].uri === pathnameParts?.[0]) {
                    withId = !!menu[1].id;
                    hasTabs = !!menu[1]?.tabs;
                }
            });

        switch (pathnameParts?.length) {
        case 1: {
            tabName = pathnameParts?.[0];

            break;
        }

        case PATHNAME_NOSUBID_LENGTH: {
            if (withId && !hasTabs) {
                tabName = pathnameParts?.[0];
            } else if (!hasIdInPathname) {
                tabName = pathnameParts?.[0] + '/' + pathnameParts?.[1];
            }

            break;
        }

        case PATHNAME_SUBID_LENGTH: {
            if (withId && hasTabs) {
                if (pathnameParts?.[PATHNAME_THIRD_PART].length) {
                    tabName = pathnameParts?.[0] + '/' + pathnameParts?.[PATHNAME_THIRD_PART];
                } else if (!hasIdInPathname) {
                    tabName = pathnameParts?.[0] + '/' + pathnameParts?.[1];
                }
            }

            break;
        }
        }

        if (tabName?.[tabName.length - 1] === '/') {
            tabName = tabName.slice(0, tabName.length - 1);
        }
    }

    return tabName;
};
