import { Dict } from '../../types';

const PAGES_ALWAYS_HAS_WEBPHONE_PANEL = [
    '#/outgoing',
];

const PAGES_HAS_WEBPHONE_PANEL_ACTIVE = [
    '#/clients',
    '#/cars',
    '#/session',
    '#/tracks',
];

export const hasWebphonePanel = (href: string, blockRules?: Dict<boolean>) => {
    return (PAGES_ALWAYS_HAS_WEBPHONE_PANEL.some((url) => href.includes(url))
        || PAGES_HAS_WEBPHONE_PANEL_ACTIVE.some((url) => href.includes(url)))
        && blockRules?.WebPhone;
};
