export function isObjectEqual(value, other) {
    const typeValue = Object.prototype.toString.call(value);
    const typeOther = Object.prototype.toString.call(other);

    if (typeValue !== typeOther) {
        return false;
    }

    if (value === undefined && other === undefined) {
        return true;
    }

    if (value === null && other === null) {
        return true;
    }

    if (['[object Array]', '[object Object]'].indexOf(typeValue) < 0) {
        return false;
    }

    const valueLen = typeValue === '[object Array]' ? value.length : Object.keys(value).length;
    const otherLen = typeValue === '[object Array]' ? other.length : Object.keys(other).length;
    if (valueLen !== otherLen) {
        return false;
    }

    // Compare two items
    const compare = (item1, item2) => {

        const itemType = Object.prototype.toString.call(item1);

        if (['[object Array]', '[object Object]'].indexOf(itemType) >= 0) {
            return isObjectEqual(item1, item2);
        }

        // If the two items are not the same type, return false
        if (itemType !== Object.prototype.toString.call(item2)) {
            return false;
        }

        // Else if it's a function, convert to a string and compare
        // Otherwise, just compare
        if (itemType === '[object Function]') {
            return item1.toString() === item2.toString();
        }

        return item1 === item2;

    };

    // Compare properties
    if (typeValue === '[object Array]') {
        for (let i = 0; i < valueLen; i++) {
            if (!compare(value[i], other[i])) {
                return false;
            }
        }
    } else {
        for (const key in value) {
            if (value.hasOwnProperty(key)) {
                if (!compare(value[key], other[key])) {
                    return false;
                }
            }
        }
    }

    // If nothing failed, return true
    return true;
}
