import { ENVIRONMENT, GeoPointsKeys, IChatSettings, LANGUAGES, LSDefaultSettings } from '../../../types';
import { GEO_POINTS, HOST } from '../../constants';
import { CS_DEFAULT_SETTINGS } from '../customSettings/defaults';

const defaultChatSettings: IChatSettings = {
    menuIsOpen: true,
    lineIsOpen: true,
    feedIsOpen: true,
};

export const LS_DEFAULT_SETTINGS: LSDefaultSettings = {
    city: GeoPointsKeys.MOSCOW,
    env: ENVIRONMENT.ADMIN,
    custom_env: `https://${ENVIRONMENT.TESTING}.${HOST}`,
    lang: LANGUAGES.ENG,
    compact_bots_view: true,
    selectedBotsCtypes: [],
    selectedBotsTypes: [],
    chatSettings: defaultChatSettings,
    selectedRoleTab: '',
    _da_doNotFilterTagsType: '',
    incident_types_filter: [],
    defaultSelectedFilterExcept: '',
    map_settings: {
        filters: {
            model_id: '',
            idle_start: '',
            status: '',
            offer_name: '',
        },
        current_position: {
            center: GEO_POINTS.MOSCOW.OPTIONS.center,
            zoom: GEO_POINTS.MOSCOW.OPTIONS.zoom,
        },
        typeSelector: 'yandex#map',
    },
    tags_filter: '',
    customSettings: CS_DEFAULT_SETTINGS,
    extra_accounts: [],
};
