import React from 'react';

import RedirectByPhone from '../components/RedirectByPhone';
import { chunksErrorHandling } from './chunksErrorHandling';
import { ITabViewProps, TabView } from './TabView';

const SessionCard = React.lazy(() => chunksErrorHandling(() => import('../components/SessionCard')));
const SessionCardBilling = React
    .lazy(() => chunksErrorHandling(() => import ('../components/SessionCard/SessionCardBilling')));
const SessionCardAcceptancePhotos = React
    .lazy(() => chunksErrorHandling(() => import ('../components/SessionCard/SessionCardAcceptancePhotos')));
const SessionCardFueling = React
    .lazy(() => chunksErrorHandling(() => import ('../components/SessionCard/SessionCardFueling')));
const SessionCardInsurance = React
    .lazy(() => chunksErrorHandling(() => import ('../components/SessionCard/SessionCardInsurance')));
const SessionCardService = React
    .lazy(() => chunksErrorHandling(() => import ('../components/SessionCard/SessionCardService')));
const UserActionsView = React.lazy(() => chunksErrorHandling(() => import('../components/Clients/UserActionsView')));
const UserRolesView = React.lazy(() => chunksErrorHandling(() => import('../components/Clients/UserRolesView')));
const UserInfoView = React.lazy(() => chunksErrorHandling(() => import('../components/Clients/UserInfoView')));
const DocumentsView = React.lazy(() => chunksErrorHandling(() => import( '../components/Clients/DocumentsView')));
const BillingView = React.lazy(() => chunksErrorHandling(() => import( '../components/Clients/BillingView')));
const BonusView = React.lazy(() => chunksErrorHandling(() => import( '../components/Clients/BonusView')));
const Clients = React.lazy(() => chunksErrorHandling(() => import ('../components/Clients')));
const ClientsView = React.lazy(() => chunksErrorHandling(() => import ('../components/Clients/ClientsView')));
const CarCard = React.lazy(() => chunksErrorHandling(() => import ('../components/CarCard')));
const CarPhotos = React.lazy(() => chunksErrorHandling(() => import ('../components/CarCard/CarPhotos')));
const CarTelematics = React.lazy(() => chunksErrorHandling(() => import ('../components/CarCard/CarTelematics')));
const CarEditor = React.lazy(() => chunksErrorHandling(() => import ('../components/CarCard/CarEditor')));
const CarInfo = React.lazy(() => chunksErrorHandling(() => import ('../components/CarCard/CarInfo')));
const CCView = React.lazy(() => chunksErrorHandling(() => import ('../components/Clients/CCView')));
const UserTagsView = React.lazy(() => chunksErrorHandling(() => import ('../components/Clients/UserTagsView')));
const UserRequestAggregator = React
    .lazy(() => chunksErrorHandling(() => import ('../components/Clients/UserRequestAggregator')));
const FinesView = React.lazy(() => chunksErrorHandling(() => import ('../components/Clients/FinesView')));
const CarTagsPhotos = React.lazy(() => chunksErrorHandling(() => import ('../components/CarCard/CarTagsPhotos')));
const CarGarage = React.lazy(() => chunksErrorHandling(() => import ('../components/CarCard/CarGarage/index')));
const CarIncidents = React.lazy(() => chunksErrorHandling(() => import ('../components/CarCard/CarIncidents')));
const CarTagsView = React.lazy(() => chunksErrorHandling(() => import ('../components/CarCard/CarTagsView')));
const RolesUsers = React.lazy(() => chunksErrorHandling(() => import ('../components/Settings/RolesUsers')));
const RoleAnalyzer = React.lazy(() => chunksErrorHandling(() => import ('../components/Settings/RoleAnalyzer')));
const CompareRoles = React.lazy(() => chunksErrorHandling(() => import ('../components/Settings/CompareRoles')));
const FuelUsages = React.lazy(() => chunksErrorHandling(() => import('../components/Clients/FuelUsages')));
const ChatsOutgoing = React.lazy(() => chunksErrorHandling(() => import('../components/ChatOutgoing')));
const TrackMap = React.lazy(() => chunksErrorHandling(() => import('../components/TrackMap')));
const Users = React.lazy(() => chunksErrorHandling(() => import('../components/Users')));
const SupportAlerts = React.lazy(() => chunksErrorHandling(() => import('../components/Support/SupportAlerts')));
const GetCalls = React.lazy(() => chunksErrorHandling(() => import('../components/Support/GetCalls')));
const CallsFeed = React.lazy(() => chunksErrorHandling(() => import('../components/Support/CallsFeed')));
const SupportEvacuations = React
    .lazy(() => chunksErrorHandling(() => import('../components/Support/SupportEvacuations')));
const IncidentsFeed = React.lazy(() => chunksErrorHandling(() => import('../components/Support/IncidentsFeed')));
const Devices = React.lazy(() => chunksErrorHandling(() => import('../components/Support/Devices')));
const SupportDistribution = React
    .lazy(() => chunksErrorHandling(() => import('../components/Support/SupportDistribution')));
const Dashboard = React
    .lazy(() => chunksErrorHandling(() => import('../components/AnalyticsViews/Dashboards/component')));
const DriveLens = React.lazy(() => chunksErrorHandling(() => import('../components/AnalyticsViews/DriveLens')));
const Tree = React.lazy(() => chunksErrorHandling(() => import('../components/AnalyticsViews/Tree')));
const Registry = React.lazy(() => chunksErrorHandling(() => import('../components/AnalyticsViews/Registry')));
const FuelingB2C = React.lazy(() => chunksErrorHandling(() => import('../components/Fueling/FuelingB2C')));
const FuelTrucks = React.lazy(() => chunksErrorHandling(() => import('../components/Fueling/FuelTrucks')));
const Refuelers = React.lazy(() => chunksErrorHandling(() => import('../components/Fueling/Refuelers')));
const VinSimView = React.lazy(() => chunksErrorHandling(() => import('../components/VinSimView')));
const CustomMaintenance = React.lazy(() => chunksErrorHandling(() => import('../components/Garage/CustomMaintenance')));
const DocsQueue = React.lazy(() => chunksErrorHandling(() => import('../components/Documents/DocsQueue')));
const DocsTemplates = React.lazy(() => chunksErrorHandling(() => import('../components/Documents/DocsTemplates')));
const CarsPackage = React.lazy(() => chunksErrorHandling(() => import('../components/Garage/CarsPackage')));
const AirportsInfoComparator = React
    .lazy(() => chunksErrorHandling(() => import('../components/Garage/AirportsInfoComparator')));
const FuelCardsUploader = React.lazy(() => chunksErrorHandling(() => import('../components/Garage/FuelCardsUploader')));
const Wheels = React.lazy(() => chunksErrorHandling(() => import('../components/Major/Wheels')));
const Service = React.lazy(() => chunksErrorHandling(() => import('../components/Major/Service')));
const MajorStorage = React.lazy(() => chunksErrorHandling(() => import('../components/Major/MajorStorage')));
const Roles = React.lazy(() => chunksErrorHandling(() => import('../components/Settings/Roles')));
const Actions = React.lazy(() => chunksErrorHandling(() => import('../components/Settings/Actions')));
const ActionsUpdate = React.lazy(() => chunksErrorHandling(() => import('../components/Settings/ActionsUpdate')));
const Tags = React.lazy(() => chunksErrorHandling(() => import('../components/Settings/Tags/component')));
const GlobalVarsView = React.lazy(() => chunksErrorHandling(() => import('../components/Settings/GlobalVarsView')));
const Polygons = React.lazy(() => chunksErrorHandling(() => import('../components/Settings/Polygons')));
const Attributes = React.lazy(() => chunksErrorHandling(() => import('../components/Settings/Attributes')));
const Saas = React.lazy(() => chunksErrorHandling(() => import('../components/Settings/Saas')));
const ErrorLogger = React.lazy(() => chunksErrorHandling(() => import('../components/ErrorLogger/component')));
const LocalSettings = React.lazy(() => chunksErrorHandling(() => import('../components/LocalSettings')));
const LocalSettingsCompare = React.lazy(() => chunksErrorHandling(() => import('../components/LocalSettingsCompare')));
const ExternalPromo = React.lazy(() => chunksErrorHandling(() => import('../components/Settings/ExternalPromo')));
const FormConstructorView = React.lazy(() => chunksErrorHandling(() => import('../components/FormConstructorView')));
const MLModels = React.lazy(() => chunksErrorHandling(() => import('../components/Settings/MLModels')));
const MDS = React.lazy(() => chunksErrorHandling(() => import('../components/Settings/MDS')));
const ModelEditor = React.lazy(() => chunksErrorHandling(() => import('../components/Settings/ModelEditor')));
const StatusEditor = React.lazy(() => chunksErrorHandling(() => import('../components/Settings/StatusEditor')));
const NewUser = React.lazy(() => chunksErrorHandling(() => import('../components/Settings/NewUser')));
const Wallets = React.lazy(() => chunksErrorHandling(() => import('../components/Settings/Wallets')));
const Promo = React.lazy(() => chunksErrorHandling(() => import('../components/Settings/Promo')));
const Notifiers = React.lazy(() => chunksErrorHandling(() => import('../components/Settings/Notifiers')));
const ChatsEditor = React.lazy(() => chunksErrorHandling(() => import('../components/Settings/ChatsEditor')));
const BotsView = React.lazy(() => chunksErrorHandling(() => import('../components/Settings/BotsView')));
const ClassificationTree = React
    .lazy(() => chunksErrorHandling(() => import('../components/Settings/ClassificationTree')));
const ChatReport = React
    .lazy(() => chunksErrorHandling(() => import('../components/Support/CustomReports/ChatReport')));
const DutyReport = React
    .lazy(() => chunksErrorHandling(() => import('../components/Support/CustomReports/DutyReport')));
const Landings = React.lazy(() => chunksErrorHandling(() => import('../components/Settings/Landings')));
const PromocodeWizard = React.lazy(() => chunksErrorHandling(() => import('../components/Settings/PromocodeWizard')));
const Confirmations = React.lazy(() => chunksErrorHandling(() => import('../components/Confirmations')));
const MoveTags = React.lazy(() => chunksErrorHandling(() => import('../components/Migrate/MoveTags')));
const MoveBots = React.lazy(() => chunksErrorHandling(() => import('../components/Migrate/MoveBots')));
const MoveNotifiers = React.lazy(() => chunksErrorHandling(() => import('../components/Migrate/MoveNotifiers')));
const MoveAreas = React.lazy(() => chunksErrorHandling(() => import('../components/Migrate/MoveAreas')));
const Chats = React.lazy(() => chunksErrorHandling(() => import('../components/Chats')));
const IntroScreensDeadline = React
    .lazy(() => chunksErrorHandling(() => import('../components/Settings/IntroscreensDeadline/index')));
const MoveActions = React.lazy(() => chunksErrorHandling(() => import('../components/Migrate/MoveActions')));
const MoveRoles = React.lazy(() => chunksErrorHandling(() => import('../components/Migrate/MoveRoles')));
const RolesUsersArbitraryList = React
    .lazy(() => chunksErrorHandling(() => import('../components/Settings/RolesUsers/RolesUsersArbitraryList')));
const ChatDeferUntil = React
    .lazy(() => chunksErrorHandling(() => import('../components/InterfaceAdminConfig/ChatDeferUntil')));
const CreateOutgoingChat = React
    .lazy(() => chunksErrorHandling(() => import('../components/InterfaceAdminConfig/CreateOutgoingChat')));
const FastAnswers = React
    .lazy(() => chunksErrorHandling(() => import('../components/InterfaceAdminConfig/FastAnswers')));
const GibddDepartments = React
    .lazy(() => chunksErrorHandling(() => import('../components/InterfaceAdminConfig/GibddDepartments')));
const ModelSegments = React
    .lazy(() => chunksErrorHandling(() => import('../components/InterfaceAdminConfig/ModelSegments')));
const UISettingsConf = React
    .lazy(() => chunksErrorHandling(() => import('../components/InterfaceAdminConfig/UISettings')));
const BlockRules = React.lazy(() => chunksErrorHandling(() => import('../components/InterfaceAdminConfig/BlockRules')));
const FastTags = React.lazy(() => chunksErrorHandling(() => import('../components/InterfaceAdminConfig/FastTags')));
const ImportantCarTags = React
    .lazy(() => chunksErrorHandling(() => import('../components/InterfaceAdminConfig/ImportantCarTags')));
const SystemAlerts = React
    .lazy(() => chunksErrorHandling(() => import('../components/InterfaceAdminConfig/SystemAlerts')));
const PolyFilters = React
    .lazy(() => chunksErrorHandling(() => import('../components/InterfaceAdminConfig/PolyFilters')));
const AggregateTags = React
    .lazy(() => chunksErrorHandling(() => import('../components/InterfaceAdminConfig/AggregateTags')));
const Emergency = React.lazy(() => chunksErrorHandling(() => import('../components/Support/Emergency')));
const ExportPolygon = React.lazy(() => chunksErrorHandling(() => import('../components/Settings/ExportPolygon')));
const SessionsList = React.lazy(() => chunksErrorHandling(() => import('../components/SessionsList')));
const LiteConfirmations = React.lazy(() => chunksErrorHandling(() => import('../components/LiteConfirmations')));
const Wallets2 = React.lazy(() => chunksErrorHandling(() => import('../components/B2B/SearchWallets')));
const ChatWelcomesList = React
    .lazy(() => chunksErrorHandling(() => import('../components/InterfaceAdminConfig/ChatWelcomesList')));
const ChatApologizesList = React
    .lazy(() => chunksErrorHandling(() => import('../components/InterfaceAdminConfig/ChatApologizesList')));
//const ChatsTree = React.lazy(() => chunksErrorHandling(() => import('../components/Settings/ChatsTree/index')));
const RegistrationFlow = React
    .lazy(() => chunksErrorHandling(() => import('../components/InterfaceAdminConfig/RegistrationFlow')));
const RegistrationFlowNew = React
    .lazy(() => chunksErrorHandling(() => import('../components/InterfaceAdminConfig/RegistrationFlowNew')));
const CallSourceList = React
    .lazy(() => chunksErrorHandling(() => import('../components/InterfaceAdminConfig/CallSourceList')));
const BillingCalculatorOfferNames = React
    .lazy(() => chunksErrorHandling(() => import('../components/InterfaceAdminConfig/BillingCalculatorOfferNames')));
const LongtermOffers = React.lazy(() => chunksErrorHandling(() => import('../components/Support/LongtermOffers')));
const LeasingStats = React.lazy(() => chunksErrorHandling(() => import('../components/Leasing/LeasingStats')));
const DispatcherSettings = React
    .lazy(() => chunksErrorHandling(() => import('../components/InterfaceAdminConfig/DispatcherSettings')));
const ExportPolygonQuery = React
    .lazy(() => chunksErrorHandling(() => import('../components/InterfaceAdminConfig/ExportPolygonsQuery')));
const AdditionalWebphoneNumber = React
    .lazy(() => chunksErrorHandling(() => import('../components/InterfaceAdminConfig/AdditionalWebphoneNumber')));
const Voyage = React.lazy(() => chunksErrorHandling(() => import('../components/Voyage')));
const CreateWallets = React.lazy(() => chunksErrorHandling(() => import('../components/B2B/CreateWallets')));
const AnalyticsGarage = React
    .lazy(() => chunksErrorHandling(() => import('../components/AnalyticsViews/AnalyticsGarage')));
const DedicatedFleetLinks = React
    .lazy(() => chunksErrorHandling(() => import('../components/InterfaceAdminConfig/DedicatedFleetLinks')));
const TransformToScooter = React
    .lazy(() => chunksErrorHandling(() => import('../components/InterfaceAdminConfig/TransformToScooter')));
const NamedFilters = React.lazy(() => chunksErrorHandling(() => import('../components/InterfaceAdminConfig/NamedFilters')));
const UserRequests = React.lazy(() => chunksErrorHandling(() => import('../components/Clients/UserRequests')));
const EditorB2C = React.lazy(() => chunksErrorHandling(() => import('../components/Support/EditorB2C')));
const DmFlags = React.lazy(() => chunksErrorHandling(() => import('../components/Settings/DmFlags')));
const IntroscreenSimplified = React
    .lazy(() => chunksErrorHandling(() => import('../components/Settings/IntroscreenSimplified')));

export interface INavigation {
    ROUTES: INavigationRoute;
}

export interface INavigationRouteItem {
    uri: string;
    ui: any;
    id?: string;
    withExtraId?: boolean;
    order: number;
    tabs?: INavigationRouteItem[];
}

export interface INavigationRoute {
    [key: string]: INavigationRouteItem;
}

export const ComingSoon = () => {
    return <div>Уже скоро 🔥</div>;
};

export enum FinesRoutes {
    clients = 'clients',
    cars = 'cars'
}

export const NAVIGATION: INavigation = {
    ROUTES: {
        ['TrackMap']: {
            uri: 'tracks',
            order: 0,
            ui: TrackMap,
        },
        ['USERS']: {
            uri: 'users',
            order: 0,
            ui: Users,
        },
        ['SUPPORT']: {
            uri: 'support',
            order: 1,
            ui: (props: ITabViewProps) => {
                return <TabView {...props}/>;
            },
            tabs: [
                {
                    uri: 'alerts',
                    order: 0,
                    ui: SupportAlerts,
                },
                {
                    uri: 'calls-feed',
                    order: 1,
                    ui: CallsFeed,
                },
                {
                    uri: 'current-calls',
                    order: 2,
                    ui: GetCalls,
                },
                {
                    uri: 'probably-evacuated',
                    order: 3,
                    ui: SupportEvacuations,
                },
                {
                    uri: 'incidents-feed',
                    order: 4,
                    ui: () => {
                        return <IncidentsFeed hideColumns={{ photo: true }}/>;
                    },
                },
                {
                    uri: 'devices',
                    order: 5,
                    ui: Devices,
                },
                {
                    uri: 'distribution',
                    order: 6,
                    ui: SupportDistribution,
                },
                {
                    uri: 'emergency',
                    order: 8,
                    ui: Emergency,
                },
                {
                    uri: 'classification-tree',
                    order: 9,
                    ui: ClassificationTree,
                },
                {
                    uri: 'chat-report',
                    order: 9,
                    ui: ChatReport,
                },
                {
                    uri: 'duty-report',
                    order: 9,
                    ui: DutyReport,
                },
                {
                    uri: 'voyage',
                    order: 0,
                    ui: Voyage,
                },
                {
                    uri: 'editorB2C',
                    order: 0,
                    ui: EditorB2C,
                },
            ],
        },
        ['ANALYTICS']: {
            uri: 'analytics',
            order: 1,
            ui: (props: ITabViewProps) => {
                return <TabView {...props}/>;
            },
            tabs: [
                {
                    uri: 'dashboards',
                    order: 1,
                    ui: Dashboard,
                },
                {
                    uri: 'drive-lens',
                    order: 2,
                    ui: DriveLens,
                },
                {
                    uri: 'tree',
                    order: 4,
                    ui: Tree,
                },
                {
                    uri: 'registry',
                    order: 5,
                    ui: Registry,
                },
                {
                    uri: 'analytics-garage',
                    order: 6,
                    ui: AnalyticsGarage,
                },
            ],
        },
        ['CHATS']: {
            uri: 'chats',
            order: 1,
            ui: Chats,
        },
        ['OUTGOING']: {
            uri: 'outgoing',
            order: 1,
            ui: ChatsOutgoing,
        },
        ['FUELING']: {
            uri: 'fueling',
            order: 1,
            ui: (props: ITabViewProps) => {
                return <TabView {...props}/>;
            },
            tabs: [
                {
                    uri: 'b2c',
                    order: 1,
                    ui: FuelingB2C,
                },
                {
                    uri: 'fuel-trucks',
                    order: 2,
                    ui: FuelTrucks,
                },
                {
                    uri: 'refuelers',
                    order: 2,
                    ui: Refuelers,
                },
            ],
        },
        ['GARAGE']: {
            uri: 'garage',
            order: 1,
            ui: (props: ITabViewProps) => {
                return <TabView {...props}/>;
            },
            tabs: [
                {
                    uri: 'vin_sim_view',
                    order: 1,
                    ui: VinSimView,
                },
                {
                    uri: 'maintenance',
                    order: 2,
                    ui: CustomMaintenance,
                },
                {
                    uri: 'docs-queue',
                    order: 3,
                    ui: DocsQueue,
                },
                {
                    uri: 'docs-templates',
                    order: 3,
                    ui: DocsTemplates,
                },
                {
                    uri: 'cars-package',
                    order: 5,
                    ui: CarsPackage,
                },
                {
                    uri: 'airports',
                    order: 6,
                    ui: AirportsInfoComparator,
                },
                {
                    uri: 'fuel-cards',
                    order: 7,
                    ui: FuelCardsUploader,
                },
            ],
        },
        ['MAJOR']: {
            uri: 'major',
            order: 1,
            ui: (props: ITabViewProps) => {
                return <TabView {...props}/>;
            },
            tabs: [
                {
                    uri: 'wheels',
                    order: 1,
                    ui: Wheels,
                },
                {
                    uri: 'service',
                    order: 1,
                    ui: Service,
                },
                {
                    uri: 'storage',
                    order: 1,
                    ui: MajorStorage,
                },
            ],
        },
        ['PHONE']: {
            uri: 'phone',
            id: 'number',
            order: 0,
            ui: (props) => {
                const number = props?.match?.params?.number;

                return <RedirectByPhone number={number}/>;
            },
        },
        ['USER-TAGS']: {
            uri: 'user-tags',
            order: 0,
            ui: ClientsView,
        },
        ['CLIENTS']: {
            uri: 'clients',
            order: 0,
            id: 'client_id',
            ui: (props: ITabViewProps) => {
                const userId = props?.match?.params?.client_id;

                return <Clients userId={userId} {...props}/>;
            },
            tabs: [
                {
                    uri: 'info',
                    order: 1,
                    ui: (props: ITabViewProps) => {
                        const userId = props.match && props.match.params && props.match.params.client_id || null;

                        return <CCView userId={userId}/>;
                    },
                },
                {
                    uri: 'info-old',
                    order: 1,
                    ui: (props: ITabViewProps) => {
                        const userId = props.match && props.match.params && props.match.params.client_id || null;

                        return <UserInfoView userId={userId}/>;
                    },
                },
                {
                    uri: 'request_aggregator',
                    order: 1,
                    ui: (props: ITabViewProps) => {
                        const userId = props.match && props.match.params && props.match.params.client_id || null;

                        return <UserRequests userId={userId}/>;
                    },
                },
                {
                    uri: 'request_aggregator_old',
                    order: 1,
                    ui: (props: ITabViewProps) => {
                        const userId = props.match && props.match.params && props.match.params.client_id || null;

                        return <UserRequestAggregator userId={userId}/>;
                    },
                },
                {
                    uri: 'docs',
                    order: 1,
                    ui: (props: ITabViewProps) => {
                        const userId = props.match && props.match.params && props.match.params.client_id || null;

                        return <DocumentsView userId={userId}/>;
                    },
                },
                {
                    uri: 'sessions',
                    order: 1,
                    ui: (props: ITabViewProps) => {
                        const userId = props.match && props.match.params && props.match.params.client_id || null;

                        return <SessionsList userId={userId}/>;
                    },
                },
                {
                    uri: 'fueling',
                    order: 1,
                    ui: (props: ITabViewProps) => {
                        const userId = props.match && props.match.params && props.match.params.client_id || null;

                        return <FuelUsages userId={userId}/>;
                    },
                },
                {
                    uri: 'penalty',
                    order: 1,
                    ui: (props: ITabViewProps) => {
                        const userId = props.match && props.match.params && props.match.params.client_id || null;

                        return <FinesView userId={userId} route={FinesRoutes.clients}/>;
                    },
                },
                {
                    uri: 'billing',
                    order: 1,
                    ui: (props: ITabViewProps) => {
                        const userId = props.match && props.match.params && props.match.params.client_id || null;

                        return <BillingView userId={userId}/>;
                    },
                },
                {
                    uri: 'bonuses',
                    order: 1,
                    ui: (props: ITabViewProps) => {
                        const userId = props.match && props.match.params && props.match.params.client_id || null;

                        return <BonusView userId={userId}/>;
                    },
                },
                {
                    uri: 'tags-history',
                    order: 1,
                    ui: (props: ITabViewProps) => {
                        const userId = props.match && props.match.params && props.match.params.client_id || null;

                        return <UserTagsView userId={userId}/>;
                    },
                },
                {
                    uri: 'user-access',
                    order: 1,
                    ui: (props: ITabViewProps) => {
                        const userId = props.match && props.match.params && props.match.params.client_id || null;

                        return <UserRolesView userId={userId}/>;
                    },
                },
                {
                    uri: 'user-actions',
                    order: 1,
                    ui: (props: ITabViewProps) => {
                        const userId = props.match && props.match.params && props.match.params.client_id || null;

                        return <UserActionsView userId={userId}/>;
                    },
                },
            ],
        },
        ['CARS']: {
            uri: 'cars',
            order: 0,
            id: 'car_id',
            withExtraId: true,
            ui: (props: ITabViewProps) => {
                const carId = props.match && props.match.params && props.match.params.car_id;

                return <CarCard carId={carId} {...props} />;
            },
            tabs: [
                {
                    uri: 'info',
                    order: 1,
                    ui: (props: ITabViewProps) => {
                        const carId = props.match && props.match.params && props.match.params.car_id;

                        return <CarInfo carId={carId} {...props}/>;
                    },
                },
                {
                    uri: 'penalty',
                    order: 2,
                    ui: (props: ITabViewProps) => {
                        const carId = props.match && props.match.params && props.match.params.car_id || null;

                        return <FinesView carId={carId} route={FinesRoutes.cars}/>;
                    },
                },
                {
                    uri: 'fueling',
                    order: 3,
                    ui: (props: ITabViewProps) => {
                        const carId = props.match && props.match.params && props.match.params.car_id || null;

                        return <FuelUsages carId={carId}/>;
                    },
                },
                {
                    uri: 'sessions',
                    order: 3,
                    ui: (props: ITabViewProps) => {
                        const carId = props.match && props.match.params && props.match.params.car_id || null;

                        // return <SessionView carId={carId}/>;
                        return <SessionsList carId={carId}/>;
                    },
                },
                {
                    uri: 'acceptance_photos',
                    order: 4,
                    ui: (props: ITabViewProps) => {
                        const carId = props.match && props.match.params && props.match.params.car_id || null;

                        return <CarPhotos carId={carId}/>;
                    },
                },
                {
                    uri: 'tags_photos',
                    order: 5,
                    ui: (props: ITabViewProps) => {
                        const carId = props.match && props.match.params && props.match.params.car_id || null;

                        return <CarTagsPhotos carId={carId}/>;
                    },
                },
                {
                    uri: 'editor',
                    order: 5,
                    ui: (props: ITabViewProps) => {
                        const carId = props.match && props.match.params && props.match.params.car_id || null;

                        return <CarEditor carId={carId}/>;
                    },
                },
                {
                    uri: 'telematics',
                    order: 1,
                    ui: (props: ITabViewProps) => {
                        const carId = props.match && props.match.params && props.match.params.car_id || null;

                        return <CarTelematics carId={carId}/>;
                    },
                },
                {
                    uri: 'tags',
                    order: 1,
                    ui: (props: ITabViewProps) => {
                        const carId = props.match && props.match.params && props.match.params.car_id || null;

                        return <CarTagsView carId={carId}/>;
                    },
                },
                {
                    uri: 'garage',
                    order: 7,
                    ui: (props: ITabViewProps) => {
                        const carId = props.match && props.match.params && props.match.params.car_id || null;

                        return <CarGarage carId={carId}/>;
                    },
                },
                {
                    uri: 'incidents',
                    order: 8,
                    ui: (props: ITabViewProps) => {
                        const carId = props.match && props.match.params && props.match.params.car_id || null;

                        return <CarIncidents carId={carId}/>;
                    },
                },
            ],
        },
        ['SESSION']: {
            uri: 'session',
            order: 0,
            id: 'session_id',
            ui: (props: ITabViewProps) => {
                const sessionId = props.match && props.match.params && props.match.params.session_id;

                return <SessionCard sessionId={sessionId} {...props}/>;
            },
            tabs: [
                {
                    uri: 'billing',
                    order: 1,
                    ui: (props: ITabViewProps) => {
                        const sessionId = props.match && props.match.params && props.match.params.session_id;

                        return <SessionCardBilling sessionId={sessionId}/>;
                    },
                },
                {
                    uri: 'photos',
                    order: 2,
                    ui: (props: ITabViewProps) => {
                        const sessionId = props.match && props.match.params && props.match.params.session_id;

                        return <SessionCardAcceptancePhotos sessionId={sessionId}/>;
                    },
                },
                {
                    uri: 'fueling',
                    order: 3,
                    ui: SessionCardFueling,
                },
                {
                    uri: 'insurance',
                    order: 3,
                    ui: SessionCardInsurance,
                },
                {
                    uri: 'session-service',
                    order: 3,
                    ui: SessionCardService,
                },
            ],
        },
        ['SETTINGS']: {
            uri: 'settings',
            order: 1,
            ui: (props: ITabViewProps) => {
                return <TabView {...props}/>;
            },
            tabs: [
                {
                    uri: 'roles',
                    order: 1,
                    ui: Roles,
                },
                {
                    uri: 'actions',
                    order: 2,
                    ui: Actions,
                },
                {
                    uri: 'tags',
                    order: 2,
                    ui: Tags,
                },
                {
                    uri: 'global-vars',
                    order: 3,
                    ui: GlobalVarsView,
                },
                {
                    uri: 'poly',
                    order: 4,
                    ui: Polygons,
                },
                {
                    uri: 'export-polygon',
                    order: 4,
                    ui: ExportPolygon,
                },
                {
                    uri: 'attributes',
                    order: 5,
                    ui: Attributes,
                },
                {
                    uri: 'saas',
                    order: 6,
                    ui: Saas,
                },
                {
                    uri: 'error-log',
                    order: 7,
                    ui: ErrorLogger,
                },
                {
                    uri: 'local',
                    order: 8,
                    ui: LocalSettings,
                },
                {
                    uri: 'local-compare',
                    order: 9,
                    ui: LocalSettingsCompare,
                },
                {
                    uri: 'external-promo',
                    order: 10,
                    ui: ExternalPromo,
                },
                {
                    uri: 'form-constructor',
                    order: 12,
                    ui: FormConstructorView,
                },
                {
                    uri: 'ml-models',
                    order: 13,
                    ui: MLModels,
                },
                {
                    uri: 'mds',
                    order: 14,
                    ui: MDS,
                },
                {
                    uri: 'model-editor',
                    order: 15,
                    ui: ModelEditor,
                },
                {
                    uri: 'status-editor',
                    order: 16,
                    ui: StatusEditor,
                },
                {
                    uri: 'new-user',
                    order: 17,
                    ui: NewUser,
                },
                {
                    uri: 'wallets',
                    order: 18,
                    ui: Wallets,
                },
                {
                    uri: 'promo',
                    order: 19,
                    ui: Promo,
                },
                {
                    uri: 'notifiers',
                    order: 20,
                    ui: Notifiers,
                },
                {
                    uri: 'chat_introscreens',
                    order: 19,
                    ui: ChatsEditor,
                },
                {
                    uri: 'bots',
                    order: 20,
                    ui: BotsView,
                },
                {
                    uri: 'landings',
                    order: 23,
                    ui: Landings,
                },
                {
                    uri: 'promocode_wizard',
                    withExtraId: true,
                    order: 24,
                    ui: PromocodeWizard,
                },
                {
                    uri: 'introscreens_deadlines',
                    order: 25,
                    ui: IntroScreensDeadline,
                },
                {
                    uri: 'role-analyzer',
                    order: 25,
                    ui: RoleAnalyzer,
                },
                {
                    uri: 'dm-flags',
                    order: 25,
                    ui: DmFlags,
                },
                {
                    uri: 'introscreen-simplified',
                    order: 26,
                    ui: IntroscreenSimplified,
                },
                {
                    uri: 'actions-update',
                    order: 27,
                    ui: ActionsUpdate,
                },
            ],
        },
        ['CONFIRMATIONS']: {
            uri: 'confirmations',
            order: 2,
            ui: Confirmations,
        },
        ['MIGRATE']: {
            uri: 'migrate',
            order: 1,
            ui: (props: ITabViewProps) => {
                return <TabView {...props}/>;
            },
            tabs: [
                {
                    uri: 'move-tags',
                    order: 1,
                    ui: MoveTags,
                },
                {
                    uri: 'move-actions',
                    order: 1,
                    ui: MoveActions,
                },
                {
                    uri: 'move-roles',
                    order: 1,
                    ui: MoveRoles,
                },
                {
                    uri: 'move-bots',
                    order: 1,
                    ui: MoveBots,
                },
                {
                    uri: 'move-notifiers',
                    order: 1,
                    ui: MoveNotifiers,
                },
                {
                    uri: 'move-areas',
                    order: 1,
                    ui: MoveAreas,
                },
            ],
        },
        ['ROLES_USER']: {
            uri: 'roles-users',
            order: 1,
            ui: (props: ITabViewProps) => {
                return <TabView {...props}/>;
            },
            tabs: [
                {
                    uri: 'main',
                    order: 1,
                    ui: (props) => {
                        return <RolesUsers location={props.location}/>;
                    },
                },
                {
                    uri: 'arbitrary-list',
                    order: 2,
                    ui: RolesUsersArbitraryList,
                },
                {
                    uri: 'compare-roles',
                    order: 3,
                    ui: CompareRoles,
                },
            ],
        },
        ['INTERFACE_ADMIN_CONFIG']: {
            uri: 'interface-admin-config',
            order: 5,
            ui: (props: ITabViewProps) => {
                return <TabView {...props}/>;
            },
            tabs: [
                {
                    uri: 'chat-defer-until',
                    order: 0,
                    ui: ChatDeferUntil,
                },
                {
                    uri: 'create-outgoing-chat',
                    order: 1,
                    ui: CreateOutgoingChat,
                },
                {
                    uri: 'create-fast-answers',
                    order: 1,
                    ui: FastAnswers,
                },
                {
                    uri: 'gibdd-departments',
                    order: 1,
                    ui: GibddDepartments,
                },
                {
                    uri: 'ui-settings',
                    order: 1,
                    ui: UISettingsConf,
                },
                {
                    uri: 'block-rules',
                    order: 1,
                    ui: BlockRules,
                },

                {
                    uri: 'fast-tags',
                    order: 1,
                    ui: FastTags,
                },
                {
                    uri: 'important-car-tags',
                    order: 1,
                    ui: ImportantCarTags,
                },
                {
                    uri: 'system-alerts',
                    order: 1,
                    ui: SystemAlerts,
                },
                {
                    uri: 'poly-filters',
                    order: 1,
                    ui: PolyFilters,
                },
                {
                    uri: 'registration-flow',
                    order: 1,
                    ui: RegistrationFlow,
                },
                {
                    uri: 'registration-flow-new',
                    order: 1,
                    ui: RegistrationFlowNew,
                },
                {
                    uri: 'aggregate-tags',
                    order: 1,
                    ui: AggregateTags,
                },
                {
                    uri: 'export-polygon-query',
                    order: 1,
                    ui: ExportPolygonQuery,
                },
                {
                    uri: 'chat-welcomes-list',
                    order: 1,
                    ui: ChatWelcomesList,
                },
                {
                    uri: 'chat-apologizes-list',
                    order: 1,
                    ui: ChatApologizesList,
                },
                {
                    uri: 'model-segments',
                    order: 1,
                    ui: ModelSegments,
                },
                {
                    uri: 'call-source-list',
                    order: 1,
                    ui: CallSourceList,
                },
                {
                    uri: 'billing-calculator-offer-names',
                    order: 1,
                    ui: BillingCalculatorOfferNames,
                },
                {
                    uri: 'dispatcher-settings',
                    order: 1,
                    ui: DispatcherSettings,
                },
                {
                    uri: 'additional-webphone-number',
                    order: 1,
                    ui: AdditionalWebphoneNumber,
                },
                {
                    uri: 'dedicated-fleet-links',
                    order: 1,
                    ui: DedicatedFleetLinks,
                },
                {
                    uri: 'transform-to-scooter',
                    order: 1,
                    ui: TransformToScooter,
                },
                {
                    uri: 'named-filters',
                    order: 1,
                    ui: NamedFilters,
                },
            ],
        },
        ['LITE-CONFIRMATIONS']: {
            uri: 'lite-confirmations',
            order: 6,
            id: 'confirmation',
            ui: (props: ITabViewProps) => {
                return <LiteConfirmations location={props.location}/>;
            },
        },
        ['B2B']: {
            uri: 'b2b',
            order: 6,
            ui: (props: ITabViewProps) => {
                return <TabView {...props}/>;
            },
            tabs: [
                {
                    uri: 'search-wallets',
                    order: 1,
                    ui: Wallets2,
                },
                {
                    uri: 'create-wallets',
                    order: 2,
                    ui: CreateWallets,
                },
            ],
        },
        ['LEASING']: {
            uri: 'leasing',
            order: 6,
            ui: (props: ITabViewProps) => {
                return <TabView {...props}/>;
            },
            tabs: [
                {
                    uri: 'stats',
                    order: 1,
                    ui: LeasingStats,
                },
            ],
        },
        ['LONGTERM-OFFERS']: {
            uri: 'longterm-offers',
            order: 0,
            ui: LongtermOffers,
        },
    },
};
