import XLSX from 'xlsx';

const HEADER_LENGTH = 1;

export const readTable = (process_func) => {
    const file: HTMLInputElement = document.createElement('input');
    file.type = 'file';
    file.accept = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/vnd.ms-excel,text/csv';
    file.multiple = false;
    file.style.display = 'none';
    document.body.appendChild(file);
    file.click();
    file.onchange = (e: any) => {
        e.stopPropagation();
        e.preventDefault();
        const files = e.target.files, f = files[0];
        const reader = new FileReader();
        reader.onload = (e: any) => {
            const data = e.target.result;
            const workbook = XLSX.read(data, { type: 'binary' });
            const first_worksheet = workbook.Sheets[workbook.SheetNames[0]];
            let result: any[][] = XLSX.utils.sheet_to_json(first_worksheet, { header: HEADER_LENGTH });

            result = Array.from(new Set(
                result.map((value) => JSON.stringify(value)),
            ))
                .map((value) => JSON.parse(value));

            process_func(result);
        };

        reader.readAsBinaryString(f);
    };
};
