import { EVENT_TYPES } from './eventTypes';

export interface IEventTypesDetails {
    description: string;
    params?: string[];
    requiredParams?: string[];
}

export const EVENT_TYPES_DETAILS: { [key: string]: IEventTypesDetails } = {
    //PROD
    [EVENT_TYPES.SHOW_TAB]: {
        description: 'Переход в раздел',
        requiredParams: ['tab_name'],
    },
    [EVENT_TYPES.CLICK_BUTTON]: {
        description: 'Нажатие на кнопку',
        requiredParams: ['button_name'],
        params: ['location', 'car_id', 'user_id', 'meta'],
    },
    [EVENT_TYPES.CUSTOM_LOG]:{
        description: EVENT_TYPES.CUSTOM_LOG,
        params:['meta'],
    },
    [EVENT_TYPES.WEBPHONE_INVITE_SENT]:{
        description: 'Начало соединения вебфона',
        requiredParams: ['call_id'],
    },
    [EVENT_TYPES.PERFORMANCE_SNAPSHOT]:{
        description: 'Метрики фронтенда',
        requiredParams: ['metric'],
    },

    //TEST
    [EVENT_TYPES.TEST_EMPTY]: {
        description: 'Пустой',
    },
    [EVENT_TYPES.TEST_REQUIRED]: {
        description: 'Только обязательные параметры',
        requiredParams: ['a', 'b'],
    },
    [EVENT_TYPES.TEST_UNREQUIRED]: {
        description: 'Только необязательные параметры',
        params: ['c', 'd'],
    },
    [EVENT_TYPES.TEST_MIXED]: {
        description: 'Обязательные и небязательные параметры',
        requiredParams: ['a', 'b'],
        params: ['c', 'd', 'e'],
    },
};
