import { Dict, ENVIRONMENT, LSSettingItems } from '../../../types';
import { store } from '../../components/App/store';
import { ONE_SECOND } from '../../constants';
import { isDevOrigin } from '../frontendEnvironment';
import LS from '../localStorage/localStorage';
import { Request2 } from '../request';
import { EVENT_TYPES } from './eventTypes/eventTypes';
import { REQUESTS, SEND_LOGS_REQUESTS } from './request';
import { validateParams } from './validateParams';

interface ISendLogsParams {
    event?: EVENT_NAMES;
    data?: ISendLogsParamsData;
    store?: Dict<any>;
    target_object_id?: string;
    keepalive?: boolean;
}

export interface ISendLogsParamsData {
    event_type: EVENT_TYPES;

    [key: string]: any;
}

export enum EVENT_NAMES {
    DEFAULT = 'AdminUserEvent',
}

const VERSION_MARKER = 'v2';

export class ytLogs {
    env;
    adminUserId;
    request = new Request2({ requestConfigs: SEND_LOGS_REQUESTS });
    isTest?: boolean;
    private static instance: ytLogs;

    private constructor() {}

    public static getInstance(): ytLogs {
        if (!ytLogs.instance) {
            ytLogs.instance = new ytLogs();
        }

        return ytLogs.instance;
    }

    private getDefaultData() {
        const ls = new LS();
        this.env = ls.get(LSSettingItems.env);
        this.adminUserId = store?.getState()?.AdminUser?.userId;
    }

    async send(params: ISendLogsParams): Promise<any> {
        const { event = EVENT_NAMES.DEFAULT, data, target_object_id, keepalive = false } = params;
        this.getDefaultData();

        if (!(isDevOrigin() || this.env === ENVIRONMENT.TESTING)) {
            if (data && validateParams(data)) {
                const body = {
                    event: [event, VERSION_MARKER].join('_'),
                    data: {
                        env: this.env,
                        admin_user_id: this.adminUserId,
                        target_object_id,
                        timestamp: +(+new Date() / ONE_SECOND).toFixed(0),
                        ...data,
                    },
                };

                try {
                    return await this.request.exec(REQUESTS.SEND_LOGS, { body, keepalive });
                } catch (error) {
                    if (!this.isTest) {
                        throw error;
                    }
                }
            } else {
                if (!this.isTest) {
                    throw new Error('Wrong ytLogs parameters!');
                }
            }
        }
    }
}
