import { EVENT_TYPES_DETAILS } from '../eventTypes/eventTypesDetails';
import { ISendLogsParamsData } from '../index';

export const validateParams = (data: ISendLogsParamsData) => {
    const event_type = data?.event_type;
    if (event_type) {
        const eventTypeParams = EVENT_TYPES_DETAILS[event_type].params;
        const requiredEventTypeParams = EVENT_TYPES_DETAILS[event_type].requiredParams;
        const dataParams = Object.keys(data).filter((key) => key !== 'event_type');

        if (eventTypeParams || requiredEventTypeParams) {
            const hasAllRequired = requiredEventTypeParams?.every((key) => dataParams.includes(key)) ?? true;

            const allParams = eventTypeParams && requiredEventTypeParams
                && requiredEventTypeParams.concat(eventTypeParams) || [];

            const hasNoUnlisted = (allParams.length === 0 || dataParams.every((key) => allParams.includes(key)));

            return hasAllRequired && hasNoUnlisted;
        }

        return dataParams.length == 0;
    }

    return false;
};
