/*
import Dexie from 'dexie';
import { ENVIRONMENT, LANGUAGES } from '../../types';

export interface AdminSettings {
    name: string
    value: string
}

class AdminDatabase extends Dexie {
    public adminSettings: Dexie.Table<AdminSettings, number>; // id is number in this case

    public constructor() {
        super('AdminDatabase');
        this.version(1).stores({
            adminSettings: '&name,value'
        });
        this.adminSettings = this.table('adminSettings');
    }
}

const DB = new AdminDatabase();

const initAdminSettings: AdminSettings[] = [
    {name: 'environment', value: ENVIRONMENT.TESTING},
    {name: 'lang', value: LANGUAGES.RUS},
    {name: 'yandex_login', value: ''},
];

DB.transaction('rw', DB.adminSettings, async () => {

    let check = async (item) => {
        if ((await DB.adminSettings.where({name: item.name}).count()) === 0) {
            const id = await DB.adminSettings.add(item);
            console.log(`Added settings with id ${id}`);
        }
    };

    initAdminSettings.forEach((item) => {
        check(item);
    });

}).catch(e => {
    alert(e.stack || e);
});

export default DB;*/
