import * as React from 'react';

import { localizationNamespace } from '../../components/FileChooserDialog';
import { LOCALIZATION_RESOURCE_PREFIX } from '../../constants';
import { LocalizationReducerState } from '../../reducers/localizationReducer';
import style from '../../ui/index.css';

export class Translate {
    _translateText: LocalizationReducerState;
    _namespace: localizationNamespace;

    constructor(props: LocalizationReducerState) {
        this._translateText = props;
    }

    setNamespace(namespace: localizationNamespace) {
        this._namespace = namespace;
    }

    getItem(textId: string): string | React.ReactElement {
        return this._getValue(textId) || <BadTranslateText textId={textId}/>;
    }

    buildKey(textId: string, namespace: string) {
        return `${LOCALIZATION_RESOURCE_PREFIX}${namespace ? `${namespace}_` : ''}${textId}`;
    }

    getItemWithPrefix(textId: string): string | React.ReactElement {
        const id = this.buildKey(textId, this._namespace);

        return this._getValue(id) || <BadTranslateText textId={id}/>;
    }

    _getValue(textId: string): string {
        const textObject = this._translateText.localizations
            && this._translateText.localizations[textId] || {};
        const lang = this._translateText.currentLang;
        const value = lang && textObject && textObject.hasOwnProperty(lang)
            && textObject[lang] && textObject[lang].value || '';

        return value;
    }

    getSimpleText(textId: string) {
        return this._getValue(textId) || textId;
    }
}

export const BadTranslateText = (props) => {
    return <span data-type={'translate_error_text'}>
        <sup className={style.global_error}>*</sup>{props.textId}
    </span>;
};
