
export enum Format {
    Bold = 'bold',
    DropDownJson = 'drop-down-json',
}

export interface IFormattedItem {
    wikiFormat: Format;
    content: string;
    title: string;
}

export const wikiFormatter = (headersArr: IFormattedItem[]) => {

    return headersArr.reduce((acc, curValue) => {
        const { wikiFormat, content, title } = curValue;

        if(wikiFormat === Format.Bold) {
            return acc += `**${title}**: ${content} ---`;
        }

        if(wikiFormat === Format.DropDownJson) {
            acc += `\n<{${title}\n`;
            acc += `\n%%(json)\n`;
            acc += `${content}%%}>\n`;

            return acc;
        }

        return acc;
    }, '');
};
