import * as React from 'react';

import { Request2 } from '../../core/utils/request';
import { CLASSIFICATION_REQUESTS, REQUESTS } from './request';

interface IGetClassificationState {
    classificationIsLoading: boolean;
    classificationResponse: any;
    classificationData: any;
    classificationError: Error | null;
}

export interface IGetClassificationExport {
    getClassification?: (tag_id: string) => void;
    getClassificationResponse?: (tag_id: string) => any;
    classificationIsLoading?: boolean;
    classificationResponse?: any;
    classificationData?: any;
    classificationError?: Error | null;
}

export const GetClassification = () => (Component): any => {
    return class extends React.Component {
        state: IGetClassificationState = {
            classificationIsLoading: false,
            classificationResponse: {},
            classificationData: [],
            classificationError: null,
        };
        request = new Request2({ requestConfigs: CLASSIFICATION_REQUESTS });

        componentWillUnmount() {
            this.request.abort();
        }

        getClassification(tag_id: string) {
            tag_id && this.setState({ isLoading: true, error: null }, () => {
                this.request.exec(REQUESTS.GET_CLASSIFICATION_BY_TAGS, {
                    queryParams: { tag_id },
                })
                    .then(classificationResponse => {
                        const classificationData = classificationResponse?.categorizations?.[0]?.items || [];

                        this.setState({
                            classificationIsLoading: false,
                            classificationResponse,
                            classificationData,

                        });
                    })
                    .catch(classificationError => {
                        this.setState({
                            classificationIsLoading: false,
                            classificationError,
                        });
                    });
            });
        }

        getClassificationResponse(tag_id: string) {
            return this.request.exec(REQUESTS.GET_CLASSIFICATION_BY_TAGS, {
                queryParams: { tag_id },
            })
                .then(classificationResponse => {
                    return classificationResponse?.categorizations?.[0]?.items || [];
                });
        }

        render() {
            const {
                classificationIsLoading,
                classificationResponse,
                classificationData,
                classificationError,
            } = this.state;

            return <Component {...this.props}
                              classificationIsLoading={classificationIsLoading}
                              classificationResponse={classificationResponse}
                              classificationData={classificationData}
                              classificationError={classificationError}
                              getClassificationResponse={this.getClassificationResponse.bind(this)}
                              getClassification={this.getClassification.bind(this)}/>;
        }
    };
};
