import produce from 'immer';
import * as React from 'react';

import { requestConfigs, REQUESTS } from '../../core/components/ChatsCommon/request';
import SessionsHistoryItem, { SessionHistoryInfoHandler } from '../../core/models/session';
import { IOptionInfo } from '../../core/ui/Select';
import { Request2 } from '../../core/utils/request';
import * as style from './index.css';

interface IGetSessionsProps {
    since?: number;
    until?: number;
    session_id?: string;
    user_id?: string;
    car_id?: string;
    numdoc?: number;
    ts_since?: number;
}

export const GetSessions = (params: IGetSessionsProps) => (Component): any => {
    return class extends React.Component {
        state = {
            isLoading: false,
            error: null,
            data: {},
            options: [],
        };
        request = new Request2({ requestConfigs });

        descriptionTemplate(props) {
            return <><span className={style.model}>{props.model}</span>,
                <span> {props.number} </span>,
                <span className={style.total}>{props.total}</span></>;
        }

        getSessions(options: IGetSessionsProps) {
            this.setState(produce(this.state, draft => {
                draft.isLoading = true;
                draft.error = null;
            }), () => {

                this.request.exec(REQUESTS.SESSION_HISTORY, {
                    queryParams:
                        {
                            numdoc: options.numdoc || params.numdoc || 1,
                            ...options.user_id && { user_id: options.user_id },
                            ...options.car_id && { car_id: options.car_id },
                            ...options.session_id && { session_id: options.session_id },
                            ...options.since && { since: options.since },
                            ...options.until && { until: options.until },
                            ...options.ts_since && { ts_since: options.ts_since },
                        },
                }).then(response => {
                    this.setState(produce(this.state, draft => {
                        draft.isLoading = false;
                        draft.data = response;
                        draft.options = SessionHistoryInfoHandler.buildOptions.call(response, this.descriptionTemplate);
                        draft.error = null;
                    }));
                })
                    .catch(error => {
                        this.setState(produce(this.state, draft => {
                            draft.isLoading = false;
                            draft.error = error;
                        }));
                    });
            });
        }

        render() {
            return <Component {...this.props}
                              sessionIsLoading={this.state.isLoading}
                              sessionOptions={this.state.options}
                              sessionError={this.state.error}
                              getSessions={this.getSessions.bind(this)}
                              sessionsData={this.state.data}/>;
        }
    };
};

export interface IGetSessionsPropsExport {
    sessionIsLoading?: boolean;
    sessionOptions?: IOptionInfo[];
    sessionError?: any;
    getSessions?: (options: IGetSessionsProps) => void;
    sessionsData?: SessionsHistoryItem;
}
