import { IComponentRequest } from '../../core/utils/request';

export enum REQUESTS {
    SEARCH = 'SEARCH',
    GET_USER = 'GET_USER',
    GET_CAR = 'GET_CAR',
    GET_SESSION = 'GET_SESSION',
}

export const SEARCH_REQUESTS: IComponentRequest = {
    [REQUESTS.SEARCH]: {
        api: 'search',
        cgiObj: {
            has_all_of: null,
            limit: null,
            what: null,
        },
    },
    [REQUESTS.GET_USER]: {
        api: 'user/info',
        cgiObj: {
            user_id: null,
        },
    },
    [REQUESTS.GET_CAR]: {
        api: 'car/info',
        cgiObj: {
            car_id: null,
        },
    },
    [REQUESTS.GET_SESSION]: {
        api: 'sessions/history',
        cgiObj: {
            session_id: null,
        },
    },
};
