import { ICar } from '../../core/models/session';
import { BasicUserInfo } from '../../core/models/user';
import { GLOBAL_SEARCH_OBJECTS } from '../../core/ui/IDSelect/constants';

export interface ISearchOptions {
    has_all_of: string;
    object?: GLOBAL_SEARCH_OBJECTS;
    limit?: number;
    withSessions?: boolean;
}

export interface ISearchData {
    mixedSession?: any;
    objects: {
        cars: ICar[];
        users: BasicUserInfo[];
    };
}

export interface GlobalSearchProviderExport {
    searchIsLoading?: boolean;
    searchError?: any;
    searchIsEmpty?: boolean;
    search?: (options: ISearchOptions) => void;
    searchData?: ISearchData;
}
