import React from 'react';

import { FormConstructor } from '../../../core/components/FormConstructor';
import { Button, CancelButton, SaveButton } from '../../../core/ui/Button';
import { Window } from '../../../core/ui/FullModal';
import * as coreStyle from '../../../core/ui/index.css';
import { isObjectEqual } from '../../../core/utils/isObjectEqual';
import { deepCopy } from '../../../core/utils/utils';
import { Dict } from '../../../types';
import style from './index.css';

interface IEditFormModalProps {
    error: Error | null;
    changedData: Dict<any>;
    initialData: Dict<any>;
    formSchema: Dict<any>;
    isFormValid: boolean;
    isDataChanged: boolean;
    waitingForResponse: boolean;
    isAddingAction: boolean;
    editModalOpen: (isOpen: boolean) => void;
    onModalDataChange: (data: Dict<any>) => void;
    onAddDataSave: () => void;
    onEditDataSave: () => void;
}

interface IEditFormModalState {
}

export default class EditFormModal extends React.Component<IEditFormModalProps, IEditFormModalState> {
    render() {
        const {
            editModalOpen, error, isAddingAction, formSchema, initialData, waitingForResponse,
            onModalDataChange, onAddDataSave, changedData, onEditDataSave, isFormValid, isDataChanged,
        } = this.props;

        return <Window onClose={editModalOpen.bind(this, false)}
                       error={error}
                       className={style.modal}
                       title={isAddingAction ? 'Добавление настройки' : 'Редактирование настройки'}>

            <FormConstructor schema={formSchema}
                             initialData={deepCopy(initialData)}
                             onChange={onModalDataChange.bind(this)}/>

            <div className={coreStyle.button_container}>
                <CancelButton onClick={editModalOpen.bind(this, false)}/>

                {isAddingAction
                    ? <Button isLoading={waitingForResponse}
                              onClick={onAddDataSave.bind(this)}>Добавить</Button>
                    : <SaveButton disabled={!isDataChanged && isObjectEqual(changedData, initialData) || !isFormValid}
                                  isLoading={waitingForResponse}
                                  onClick={onEditDataSave.bind(this)}/>
                }
            </div>

        </Window>;
    }
}
