import React from 'react';

import { FormConstructor } from '../../../core/components/FormConstructor';
import { controlType, ISchemaItem } from '../../../core/components/FormConstructor/types';
import { CancelButton, SaveButton } from '../../../core/ui/Button';
import { Window } from '../../../core/ui/FullModal';
import * as coreStyle from '../../../core/ui/index.css';
import { Dict } from '../../../types';

interface IEditFormModalProps {
    error: Error | null;
    initialData: Dict<any>;
    editRawModalOpen: (isOpen: boolean) => void;
    onEditRawDataSave: (data) => void;
    isRawLoading: boolean;
}

const formSchema: Dict<ISchemaItem> = {
    text: {
        type: controlType.json,
        display_name: 'value',
    },
};

interface IEditFormModalState {
}

export default class EditRawFormModal extends React.Component<IEditFormModalProps, IEditFormModalState> {
    state: any = {
        data: null,
        isValid: true,
    };

    onChange(data) {
        this.setState({
            data,
        });
    }

    render() {
        const { error, initialData, editRawModalOpen, onEditRawDataSave, isRawLoading } = this.props;
        const text = this.state?.data?.text;
        const isValid = Array.isArray(text);

        return <Window onClose={editRawModalOpen.bind(this, false)}
                       error={error}
                       title={'Сырые даные'}>

            <FormConstructor schema={formSchema}
                             initialData={{ text: initialData }}
                             onChange={this.onChange.bind(this)}/>

            <div className={coreStyle.button_container}>
                <CancelButton isLoading={isRawLoading}
                              onClick={editRawModalOpen.bind(this, false)}/>
                <SaveButton disabled={!isValid}
                            isLoading={isRawLoading}
                            onClick={onEditRawDataSave.bind(this, text)}/>
            </div>

        </Window>;
    }
}
