import { API_PREFIXES, IComponentRequest, REQUEST_METHOD } from '../../core/utils/request';

export const REQUESTS = {
    GET_GLOBAL_SETTINGS: 'GET_GLOBAL_SETTINGS',
    UPSERT_SETTINGS: 'UPSERT_SETTINGS',
};

export const INTERFACE_ADMIN_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_GLOBAL_SETTINGS]: {
        api: 'settings/info',
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        cgiObj: {
            prefix: null,
            actuality: null,
        },
    },
    [REQUESTS.UPSERT_SETTINGS]: {
        method: REQUEST_METHOD.POST,
        api: 'settings/upsert',
    },
};
