import * as React from 'react';
import { withRouter } from 'react-router';

import { ONE_DAY, ONE_SECOND, ONE_WEEK_IN_DAYS } from '../../core/constants';
import DatePicker from '../../core/ui/DatePicker';
import style from './index.css';

export interface ISearchControls {
    since?: any;
    until?: any;
    className?: string;
    dateClassName?: string;
    isEmpty?: boolean;
    forceUrlParams?: boolean;

    [key: string]: any;
}

enum DATE {
    SINCE = 'since',
    UNTIL = 'until',
}

export const WithSearchControls = (params?: ISearchControls) => (Component: any): any => {
    class T extends React.Component<any, ISearchControls> {

        getDateParam(type: DATE) {
            const url = new URLSearchParams(this.props?.location?.search);

            return +(params?.forceUrlParams && url?.get(type) || 0);
        }

        state = {
            since: this.getDateParam(DATE.SINCE) || (params?.isEmpty
                ? undefined
                : params?.since
                    ? params?.since
                    : +new Date() - (ONE_DAY * ONE_WEEK_IN_DAYS)),
            until: this.getDateParam(DATE.UNTIL) || (params?.isEmpty
                ? undefined
                : params?.until
                    ? params?.until
                    : +new Date()),
        };

        onDateChange(param: string, value: any) {
            this.setState({
                [param]: value,
            }, () => {
                const url = new URLSearchParams(this.props?.location?.search);
                url.set(param, value);
                this.props?.history?.push(`${this.props?.location?.pathname}?${url.toString()}`);
            });
        }

        _toString(param) {
            return (+param / ONE_SECOND).toFixed(0);
        }

        render() {
            const props = {
                since: this.state.since ? this._toString(this.state.since) : undefined,
                until: this.state.until ? this._toString(this.state.until) : undefined,
            };
            const dateClassName = params?.dateClassName ? params.dateClassName : undefined;
            const rootClassName = params?.className ? params.className : undefined;

            return <div className={rootClassName}>
                <div className={dateClassName}>
                    <DatePicker value={this.state.since}
                                className={style.input}
                                placeholder={DATE.SINCE}
                                onChange={this.onDateChange.bind(this, DATE.SINCE)}/>
                    <DatePicker value={this.state.until}
                                className={style.input}
                                placeholder={DATE.UNTIL}
                                onChange={this.onDateChange.bind(this, DATE.UNTIL)}/>
                </div>
                <Component {...this.props} {...props}/>
            </div>;
        }
    }

    return withRouter(T);
};
