import * as React from 'react';

import { Request2 } from '../../core/utils/request';
import { REQUEST, REQUESTS } from './request';

export const TagDescriptions = () => (Component): any => {
    return class extends React.Component {
        state = {
            isLoading: true,
            error: null,
            tags: [],
        };
        request = new Request2({ requestConfigs: REQUEST });

        getTags() {
            this.setState({
                isLoading: true,
            }, () => {
                this.request.exec(REQUESTS.GET_TAGS)
                    .then(response => {
                        this.setState({
                            isLoading: false,
                            tags: response?.records,
                        });
                    })
                    .catch(() => {
                        this.setState({
                            isLoading: false,
                            tags: [],
                        });
                    });
            });
        }

        render() {
            return <Component {...this.props}
                              tagIsLoading={this.state.isLoading}
                              getTags={this.getTags.bind(this)}
                              tagsObject={this.state.tags?.reduce((_p, _c: any) => {
                                  if (!_p.hasOwnProperty(_c.name)) {
                                      _p[_c.name] = _c;
                                  }

                                  return _p;
                              }, {})}/>;
        }
    };
};

export interface ITagDescriptionsPropsExport {
    tagIsLoading?: boolean;
    tagsObject?: any;
    getTags?: () => void;
}
