import * as React from 'react';

import { Request2 } from '../../core/utils/request';
import { CLIENTS_CHATS_REQUEST, REQUESTS } from './request';

export const UserTags = () => (Component): any => {
    return class extends React.Component {
        state = {
            isLoading: true,
            error: null,
            tags: [],
        };
        request = new Request2({ requestConfigs: CLIENTS_CHATS_REQUEST });

        getTags(props) {
            props.object_id && this.setState({
                isLoading: props.setLoading ?? true,
            }, () => {
                this.getTagsPromise({ object_id: props.object_id })
                    .then((response: any) => {
                        this.setState({
                            isLoading: false,
                            tags: response?.records || [],
                        });
                    })
                    .catch(() => {
                        this.setState({
                            isLoading: false,
                            tags: [],
                        });
                    });
            });
        }

        getTagsPromise(props) {
            return new Promise((resolve, reject) => {
                props.object_id && this.request.exec(REQUESTS.GET_USER_TAGS, {
                    queryParams: { object_id: props.object_id },
                })
                    .then(response => resolve(response))
                    .catch(error => reject(error));
            });
        }

        componentWillUnmount() {
            this.request.abort();
        }

        render() {
            return <Component {...this.props}
                              tagIsLoading={this.state.isLoading}
                              getTags={this.getTags.bind(this)}
                              getTagsPromise={this.getTagsPromise.bind(this)}
                              tags={this.state.tags || []}/>;
        }
    };
};

export interface ITagsWithPropsExport {
    tagIsLoading?: boolean;
    tags?: any[];
    getTags?: (options: { object_id?: string; setLoading?: boolean }) => void;
    getTagsPromise?: (options: { object_id?: string }) => void;
}
