import { RoleItem, RoleProposition } from './core/models/role';
import { BasicUserInfo } from './core/models/user';
import { CSSettingsTypes } from './core/utils/customSettings';

export interface Dict<T> {
    [key: string]: T;
}

export interface ICities {
    [key: string]: {
        name: string;
        short_name2?: string;
        short_name: string;
        short_name_en: string;
    };
}

export enum ENVIRONMENT {
    ADMIN = 'admin',
    PRESTABLE = 'prestable',
    TESTING = 'testing',
    CUSTOM = 'custom',
    QA = 'qa',
    ST = 'st',
    'LEASING-CABINET' = 'leasing-cabinet',
    DM_TEST = 'dm_test',
    DM_PRESTABLE = 'dm_prestable',
    SCOOTER = 'scooter',
    SCOOTER_TEST = 'scooter_test',
}

export const EXTRA_ENV = {
    QA: { env: 'testing', cgi: { backend_cluster: 'qa' } },
    ST: { env: 'testing', cgi: { backend_cluster: 'st' } },
    DM_TEST: { env: 'leasing-cabinet', cgi: { backend_cluster: 'testing' } },
    DM_PRESTABLE: { env: 'leasing-cabinet', cgi: { backend_cluster: 'prestable' } },
    SCOOTER: { env: 'scooter', custom_env: 'http://scooter-backend.taxi.yandex.net' },
    SCOOTER_TEST: { env: 'scooter_test', custom_env: 'http://scooter-backend.taxi.tst.yandex.net' },
};

export const ENV_GROUPS = [
    {
        name: 'Drive',
        envs: [
            ENVIRONMENT.ADMIN,
            ENVIRONMENT.PRESTABLE,
            ENVIRONMENT.TESTING,
            ENVIRONMENT.QA,
            ENVIRONMENT.ST,
            ENVIRONMENT.CUSTOM,
        ],
    },
    {
        name: 'Leasing/DM',
        envs: [
            ENVIRONMENT['LEASING-CABINET'],
            ENVIRONMENT.DM_TEST,
            ENVIRONMENT.DM_PRESTABLE,
        ],
    },
    {
        name: 'Scooter',
        envs: [
            ENVIRONMENT.SCOOTER,
            ENVIRONMENT.SCOOTER_TEST,
        ],
    },
];

export enum GeoPointsKeys {
    PITER = 'PITER',
    MOSCOW = 'MOSCOW',
    KAZAN = 'KAZAN',
    SKLAD = 'SKLAD',
    KM_47 = 'KM_47',
    SOCHI = 'SOCHI',
}

export enum USER_ACTION {
    ENTER = 'enter',
    EXIT = 'exit'
}

export interface IGeoPoint {
    LABEL: {
        short: string;
        area_tags: string;
        normal: string;
    };
    OPTIONS: {
        center: number[];
        zoom: number;
    };
}

export type ValueOf<T> = T[keyof T];

export type GeoPoints = {
    [k in GeoPointsKeys]: IGeoPoint
}

export enum LANGUAGES {
    RUS = 'rus',
    ENG = 'eng'
}

export enum LSSettingItems {
    city = 'city',
    env = 'env',
    custom_env = 'custom_env',
    lang = 'lang',
    compact_bots_view = 'compact_bots_view',
    selectedBotsTypes = 'selectedBotsTypes',
    selectedBotsCtypes = 'selectedBotsCtypes',
    chatSettings = 'chatSettings',
    selectedRoleTab = 'selectedRoleTab',
    evacuationCarsList = 'evacuationCarsList',
    _da_doNotFilterTagsType = '_da_doNotFilterTagsType',
    defaultSelectedFilterExcept = 'defaultSelectedFilterExcept',
    map_settings = 'map_settings',
    tags_filter = 'tags_filter',
    incident_types_filter = 'incident_types_filter',
    customSettings = 'customSettings',
    extra_accounts = 'extra_accounts',
}

export interface IChatSettings {
    menuIsOpen?: boolean;
    lineIsOpen?: boolean;
    feedIsOpen?: boolean;
}

export type LSDefaultSettings = {
    city: GeoPointsKeys;
    env: ENVIRONMENT;
    custom_env: string;
    lang: LANGUAGES;
    compact_bots_view: boolean;
    selectedBotsCtypes: string[];
    selectedBotsTypes: string[];
    chatSettings: IChatSettings;
    selectedRoleTab: string;
    _da_doNotFilterTagsType?: string;
    defaultSelectedFilterExcept?: string;
    map_settings: {
        filters: Dict<unknown>;
        current_position: {
            center: number[];
            zoom: number;
        };
        typeSelector?: string;
    };
    tags_filter: string;
    incident_types_filter: string[];
    customSettings: CSSettingsTypes;
    extra_accounts: Dict<any>[];
}

export enum RUNNING_MODE {
    ONLINE = 'online',
    OFFLINE = 'offline',
    TEST = 'test'
}

export interface ITagItem {
    comment: string;
    object_id: string;
    performer: string;
    priority: number;
    status?: string;
    tag: string;
    tag_id: string;
}

export interface ITagItemDescription {
    comment: string;
    display_name: string;
    index: number;
    name: string;
}

export interface ISearchTagsResultItem {
    entry_type: 'car' | 'user';
    report: BasicUserInfo[];
    total: number | null;
}

export interface ISearchTags {
    results: ISearchTagsResultItem[];
    tag_descriptions: ITagItemDescription[];
}

export interface IRolesResponse {
    propositions: RoleProposition[];
    report: RoleItem[];
    users: BasicUserInfo;
}

/*map*/

export interface ICar {
    tags?: {
        comment?: string;
        display_name: string;
        object_id: string;
        priority: number;
        tag: string;
        tag_id: string;
        parent_id?: string;
    }[];
    color: number;
    colors: string[];
    id: string;
    location: { lat: number; lon: number; areas: ILocationAreasItem[]; tags?: string[] };
    model_id: string;
    number: string;
    status: string;
    surge: { idle_start: number; kff: number; l_kff: number };
    telematics: { fuel_level: number; fuel_distance: number; mileage?: number };
    usage: string;
    vin?: string;
    offer_name?: string;
    offer_group_name?: string;
}

export interface ILocationAreasItem {
    id: string;
    tags: string[];
    title?: string;
}

export interface IPoly {
    area_coords: number[];
    mapPosition: number[];
    area_id: string;
    area_index: number;
    area_tags: string;
    area_title: string;
    area_type: string;
    hard_tags: string[];
    color: string;
}

export interface IFuelStation {
    address: string;
    columns: any[];
    location: string;
    name: string;
}

export interface ITagItem {
    comment: string;
    object_id: string;
    performer: string;
    priority: number;
    status?: string;
    tag: string;
    tag_id: string;
}

export interface ITagItemDescription {
    comment: string;
    display_name: string;
    index: number;
    name: string;
}

export interface ISearchTagsResultItem {
    entry_type: 'car' | 'user';
    report: BasicUserInfo[];
    total: number | null;
}

export interface ISearchTags {
    results: ISearchTagsResultItem[];
    tag_descriptions: ITagItemDescription[];
}

export interface IRolesResponse {
    propositions: RoleProposition[];
    report: RoleItem[];
    users: BasicUserInfo;
}

export enum TAG_ACTION {
    REMOVE = 'remove',
    ADD = 'add',
    EVOLVE = 'evolve',
    ADD_SNAPSHOT = 'add_snapshot'
}

export enum ClassificationType {
    call = 'call',
    chat = 'chat',
    call_incoming = 'call_incoming',
    call_outgoing = 'call_outgoing',
}
