const ccnCtx: Worker = self as any;

interface IConnectionsOptions {
    master: boolean;
    port: any;
}

interface IConnections {
    [key: number]: IConnectionsOptions;
}

const connections: IConnections = {};
let connected = false;

export enum SHARED_MESSAGES {
    finish = 'finish',
    focus = 'focus',
    focused = 'focused',
    init = 'init',
    start = 'start'
}

const markConnectionsAsFalse = () => {
    Object.entries(connections).forEach(el => {
        el[1].master = false;
    });
};

const register = (id, options) => {
    if (!connections.hasOwnProperty(id)) {
        markConnectionsAsFalse();
        connections[id] = options;
    }
    //console.info(`connections:`, connections);
};

const unregister = (id) => {
    delete connections[id];
    const coonArr: [string, IConnectionsOptions][] = Object.entries(connections) || [];
    if (coonArr.length) {
        coonArr[0][1].master = true;
        //console.info(`unregister: connections:`, connections);
    }
};

const setFocus = (id, state = true) => {
    markConnectionsAsFalse();
    connections[id].master = state;
    //console.info(`connections|selected`, id, connections);
};

const getMaster = () => {
    const conn = Object.entries(connections);
    let master = conn.find(el => el[1].master);
    if (!master) {
        master = conn[0];
        setFocus(conn[0][0], true);
    }

    return master[0];
};

const broadcast = () => {
    Object.entries(connections).forEach(client => {
        client[1].port.postMessage({ message: SHARED_MESSAGES.focused, id: getMaster() });
    });
};

ccnCtx.addEventListener('connect', (e: any) => {
    e?.source?.addEventListener('message', ev => {
        if (ev.data.message === SHARED_MESSAGES.start) {
            if (connected === false) {
                register(ev.data.id, { master: true, port: e.source });
                connected = true;
            } else {
                register(ev.data.id, { master: false, port: e.source });
                e.source.postMessage({ message: 'worker already inited' });
            }
        }

        if (ev.data.message === SHARED_MESSAGES.finish) {
            unregister(ev.data.id);
            broadcast();
        }

        if (ev.data.message === SHARED_MESSAGES.focus) {
            setFocus(ev.data.id, true);
            broadcast();
        }

        if (ev.data.message === SHARED_MESSAGES.init) {
            register(ev.data.id, { master: ev.data.active, port: e.source });
            broadcast();
        }
    }, false);
    e.source.start();
}, false);
