import { CHAT_REQUESTS as requestConfigs, REQUESTS } from '../core/components/Chats/request';
import { _CHATS, NChats } from '../core/components/ChatsCommon/types';
import { Request2 } from '../core/utils/request';
import CHATS_COMMAND = NChats.CHATS_COMMAND;

const ccnCtx: Worker = self as any;

const request2 = new Request2({
    requestConfigs,
});

enum REQUEST_TYPE {
    CHAT = 'chat',
    CALL = 'call',
    STATUS_TAGS = 'status_tags'
}

//let SLOW_DELTA = 1.5;

const NEW_TEMP_TIMERS = {
    MY: 2000,
    OTHERS: 10000,
};
let isFeedActive = true;

let timer: any = null;
const repeatMyChats = (props, options) => {
    clearTimeout(timer);
    if (isFeedActive) {
        timer = setTimeout(() => {
            _getMyChats(props, options);
        }, NEW_TEMP_TIMERS.MY);
    }
};

let newTimer: any = null;
const repeatNewChats = () => {
    clearTimeout(newTimer);
    if (isFeedActive) {
        newTimer = setTimeout(() => {
            _getNewChats();
        }, NEW_TEMP_TIMERS.OTHERS);
    }
};

let allTimer: any = null;
const repeatAllChats = () => {
    clearTimeout(allTimer);
    if (isFeedActive) {
        allTimer = setTimeout(() => {
            _getAllChats();
        }, NEW_TEMP_TIMERS.OTHERS);
    }
};

export const _getMyChats = (props: any, options) => {
    const { isChatRole, isCallRole, isDutyRole } = options;
    const request_types = [
        isChatRole ? REQUEST_TYPE.CHAT : null,
        isCallRole ? REQUEST_TYPE.CALL : null,
        isDutyRole ? REQUEST_TYPE.STATUS_TAGS : null,
    ].filter(el => el);
    ccnCtx.postMessage({ type: CHATS_COMMAND.SET_CHATS_LOADING, state: true, chatType: _CHATS.MY });

    request2.exec(REQUESTS.FEED, {
        queryParams: {
            performer_id: props.userId, request_types: request_types.join(','),
        },
    })
        .then(response => {
            ccnCtx.postMessage({
                type: CHATS_COMMAND.SET_CHATS,
                payload: { response, type: _CHATS.MY },
            });

            repeatMyChats(props, options);
        })
        .catch(() => {
            repeatMyChats(props, options);
        });
};

export const _getNewChats = () => {
    ccnCtx.postMessage({ type: CHATS_COMMAND.SET_CHATS_LOADING, state: true, chatType: _CHATS.NEW });
    request2.exec(REQUESTS.FEED, { queryParams: { performer_id: '0' } })
        .then(response => {
            ccnCtx.postMessage({
                type: CHATS_COMMAND.SET_CHATS,
                payload: { response, type: _CHATS.NEW },
            });

            repeatNewChats();
        })
        .catch(() => {
            repeatNewChats();
        });
};

export const _getAllChats = () => {
    ccnCtx.postMessage({ type: CHATS_COMMAND.SET_CHATS_LOADING, state: true, chatType: _CHATS.ALL });
    request2.exec(REQUESTS.FEED)
        .then(response => {
            ccnCtx.postMessage({
                type: CHATS_COMMAND.SET_CHATS,
                payload: { response, type: _CHATS.ALL },
            });

            repeatAllChats();
        })
        .catch(() => {
            repeatAllChats();
        });
};

ccnCtx.onmessage = (event) => {
    if (event.data.type === CHATS_COMMAND.INIT_CHECKING_QUEUE) {
        const ls = event.data.ls;
        request2.setOptions({ environment: ls.env, url: ls.custom_env });
        ccnCtx.postMessage({ type: CHATS_COMMAND.UPDATE_WORKER_IS_READY });
    }

    if (event.data.type === CHATS_COMMAND.START_CHECKING_QUEUE) {
        const { props, options } = event.data;
        const { isChatRole, isCallRole, isDutyRole, isFeedRequestsDisabled } = options;
        isFeedActive = true;

        if (!isFeedRequestsDisabled) {
            (isChatRole || isCallRole || isDutyRole) && _getMyChats(props, options);

            if (options.isChatRole) {
                _getNewChats();
                _getAllChats();
            }
        }
    }

    if (event.data.type === CHATS_COMMAND.FINISH_CHECKING_QUEUE) {
        isFeedActive = false;
        clearTimeout(timer);
        clearTimeout(newTimer);
        clearTimeout(allTimer);
    }
};
