const fs = require('fs');
const errorTools = require('@yandex-vh/error-tools');
const buildDir = 'dist/';
const sourceMapDir = 'dist/source-maps';
const standDomains = [
    `https://${process.env.TICKET}.stand.carsharing.yandex-team.ru`
];
const shouldUploadSourceMapsForStand = process.env.UPLOAD_STAND_SOURCE_MAPS === 'true';
const shouldUploadSourceMapsForProduction = process.env.UPLOAD_PRODUCTION_SOURCE_MAPS === 'true';
const project = 'DriveAdmin';

let productionDomains = [
    'https://carsharing.yandex-team.ru',
    'https://prestable.carsharing.yandex-team.ru',
];

const uploadSourceMapsToEB = (dir) => {
    let domains = [];

    if (shouldUploadSourceMapsForStand) {
        domains.push(...standDomains);
    }

    if (shouldUploadSourceMapsForProduction) {
        domains.push(...productionDomains);
    }

    const allScriptFiles = fs.readdirSync(buildDir)
        .filter(file => file.includes('.js'));

    fs.readdirSync(dir).forEach(file => {
        const scriptFile = allScriptFiles.find((scriptFile) => `${file.split('.')[0]}.` === `${scriptFile.split('.')[0]}.`);
        if (fs.existsSync(`${buildDir}/${scriptFile}`)) {
            if (domains.length) {
                console.info(`Upload map ${file} for ${scriptFile} started...`);

                domains.forEach((domain) => {
                    // eslint-disable-next-line no-magic-numbers
                    timeoutPromise(errorTools.uploadSourceMap(`${sourceMapDir}/${file}`, `${domain}/${scriptFile}`, project), 3000)
                        .then(() => console.info(`Upload map ${file} to ${domain} succeeded.`))
                        .catch(e => console.error(`Upload map ${file} to ${domain} failed.`, e));
                });
            }

        } else {
            console.error(`${scriptFile} for map ${file} doesn't exist`)
        }
    });
};

const timeoutPromise = (promise, ms) => {
    return new Promise(function (resolve, reject) {
        let timer = setTimeout(() => {
            reject(new Error('Request Timeout :('));
        }, ms);

        promise.then(function (res) {
            clearTimeout(timer);
            resolve(res);
        })
            .catch(function (err) {
                clearTimeout(timer);
                reject(err);
            });
    });
}

//uploadSourceMapsToEB(`${sourceMapDir}`);
