const {merge} = require('webpack-merge');

const common = require('./configs/webpack/webpack.common');
const development = require('./configs/webpack/webpack.development');
const production = require('./configs/webpack/webpack.production');
const bundle_analyzer = require('./configs/webpack/webpack.bundle_analyzer');

module.exports = ({mode, type} = {mode: 'production'}) => {
    const productionConfig = merge(common(mode), production);

    if (type === 'analyze') {
        return module.exports = merge(productionConfig, bundle_analyzer);
    }

    if (mode === 'production') {
        return module.exports = productionConfig;
    }

    if (mode === 'development') {
        return module.exports = merge(common(mode), development);
    }
};
