const errorComment = 2;
module.exports = {
    'env': {
        'browser': true,
        'es6': true
    },
    'globals': {
        'Atomics': 'readonly',
        'SharedArrayBuffer': 'readonly'
    },
    'parser': '@typescript-eslint/parser',
    'parserOptions': {
        'ecmaFeatures': {
            'jsx': true
        },
        'ecmaVersion': 11,
        'sourceType': 'module'
    },
    'plugins': [
        'react',
        '@typescript-eslint'
    ],
    'extends': [
        'plugin:react/recommended'
    ],
    'rules': {
        "curly": "error",
        "no-debugger": "error",
        "no-eval": "error",
        "no-console": [
            "error",
            {
                "allow": ["warn", "error", "info", "dir", "clear"]
            }
        ],
        "no-dupe-args": "error",
        "no-duplicate-imports": "error",
        "@typescript-eslint/no-unused-vars": [
            "error",
            {
                "vars": "all",
                "args": "none"
            }
        ],
        /*"no-magic-numbers": ["error", {
            "ignore": [-1, 0, 1]
        }],*/
        "no-warning-comments": [errorComment, {"terms": ["BIB"]}], // bring it back
        "react/jsx-key": "error",
        "react/display-name": "off",
        "react/prop-types": "off",
        "react/no-unescaped-entities": "off",
        "react/no-children-prop": "off",
        "react/jsx-no-target-blank": "off"
    },
    'settings': {
        'react': {
            'pragma': 'React',
            'version': 'detect'
        }
    }
};
