#!/bin/bash

function init() {
  echo Building Docker image...
  RELEASE_FOLDER=releases;
  # get cli arguments (-d -l -p are optional, -t is required)
  while getopts "t:d:p::" OPTION; do
    case $OPTION in
      t) DOCKER_TAG=${OPTARG};;
      d) DEPLOY_TARGET=${OPTARG};;
      p) PREVIOUS_RELEASE=${OPTARG};;
      *)
    esac
  done
}

# ls -t | sed -n Np means "list items in folder by mtime and get Nth line from output"
function findPreviousReleaseForProduction() {
  LATEST_RELEASE="$RELEASE_FOLDER"/$(ls -t | sed -n 1p);

  if [ "$PREVIOUS_RELEASE" == "" ]; then
    PREVIOUS_RELEASE="$RELEASE_FOLDER"/$(ls -t | sed -n 2p);
  else
    # check if folder exists
    if [ ! -d PREVIOUS_RELEASE ]; then
      echo Release "$PREVIOUS_RELEASE" doesn\'t exist. Exiting...
      exit;
    else
      PREVIOUS_RELEASE="$RELEASE_FOLDER"/"$PREVIOUS_RELEASE";
    fi;

  fi
}

function findPreviousReleaseForBranch() {
  LATEST_RELEASE=dist

  if [ "$PREVIOUS_RELEASE" == "" ]; then
     PREVIOUS_RELEASE="$RELEASE_FOLDER"/$(ls -t | sed -n 1p);
  else
     PREVIOUS_RELEASE="$RELEASE_FOLDER"/"$PREVIOUS_RELEASE";
  fi
}

function getReleases() {
  cd "$RELEASE_FOLDER" || exit

  if [ "$DEPLOY_TARGET" == 'production' ]; then
    findPreviousReleaseForProduction
  else
    findPreviousReleaseForBranch
  fi

  cd ..

  # check if folders are empty
  if [ ! "$(ls -A "$LATEST_RELEASE")" ]; then
      echo "$LATEST_RELEASE" folder is empty, exiting...
      exit
  fi

  if [ ! "$(ls -A "$PREVIOUS_RELEASE")" ]; then
      echo "$PREVIOUS_RELEASE" folder is empty, exiting...
      exit
  fi
}

function buildRelease {
  getReleases;

  echo DOCKER_TAG="$DOCKER_TAG"
  echo LATEST_RELEASE="$LATEST_RELEASE"
  echo PREVIOUS_RELEASE="$PREVIOUS_RELEASE"

  docker build \
    -f ./Dockerfile.emergency_admin \
    --build-arg LATEST_RELEASE="$LATEST_RELEASE" \
    --build-arg PREVIOUS_RELEASE="$PREVIOUS_RELEASE" \
    -t "$DOCKER_TAG" .
}

set -e;
# passing cli arguments to function
init "$@";
buildRelease;

