const otherVendors = ['some-custom-lib-name'];
const node_module = 'node_modules';
const VENDOR = 'vendor';
const chunks = 'all';

const isNodeModule = (module) => {
    return module.resource && module.resource.indexOf(node_module) > -1
}

const checkMainVendors = (module) => {
    return isNodeModule(module) && otherVendors.every(el => module.resource.indexOf(el) == -1)
}

const vendorItemOptions = (name, test) => {
    return {
        name,
        test,
        chunks,
    }
}

const makeOther = () => {
    return otherVendors.reduce((p, otherVendor) => {
        if (!p.hasOwnProperty(otherVendor)) {
            p[otherVendor] = vendorItemOptions(otherVendor, (module) => {
                return isNodeModule(module) && (module.resource.indexOf(otherVendor) > -1);
            })
        }
        return p;
    }, {})
}

module.exports = {
    [VENDOR]: vendorItemOptions(VENDOR, (module) => checkMainVendors(module)),
    ...makeOther()
}