const path = require('path');
const WebpackNotifierPlugin = require('webpack-notifier');

module.exports = {
    plugins: [
        new WebpackNotifierPlugin({
            excludeWarnings: true,
            title: 'Webpack'
        })
    ],
    devtool: 'eval-cheap-module-source-map',
    devServer: {
        contentBase: path.join(__dirname, 'dist'),
        compress: true,
        port: 7000,
        disableHostCheck: true,
        host: '0.0.0.0',
        stats: {
            assetsSort: '!size',
            colors: true,
            logging: 'error',
            reasons: false,
            children: false,
            usedExports: false
        },
        https: true,
        headers: {
            'Cache-Control': 'max-age=31536000'
        },
        proxy: {
            '/api/*': {
                target: 'https://pumpkin.carsharing.yandex.net/api/',
                changeOrigin: true,
                secure: false,
                pathRewrite: {
                    '^/api/': ''
                }
            }
        },
    }
};
