module.exports = {
    globals: {
        'ts-jest': {
            diagnostics: false,
            isolatedModules: true
        },
    },
    transform: {
        '.(ts|tsx)': 'ts-jest',
    },
    testPathIgnorePatterns: [
        '/node_modules/',
        '/lib/',
    ],
    testRegex: '(/test/.*|\\.(test|spec))\\.(ts|tsx|js)$',
    moduleFileExtensions: [
        'js',
        'json',
        'ts',
        'tsx',
    ],
    reporters: [
        "default",
        ["./node_modules/jest-html-reporter", {
            "pageTitle": "jest report",
            "outputPath": "./jest-report.html",
            "includeFailureMsg": true,
            "includeConsoleLog": true
        }]
    ],
    moduleNameMapper: {
        '\\.(css|less|svg|png)$': 'identity-obj-proxy',
    },
    setupFiles: [
        './setupTests.js',
        'jest-canvas-mock',
    ],
    preset: 'ts-jest',
    testMatch: null,
    snapshotSerializers: ['enzyme-to-json/serializer']
};
