import { Avatar, ListItem, ListItemAvatar, ListItemText } from '@material-ui/core';
import { Skeleton } from '@material-ui/lab';
import Typography from '@material-ui/core/Typography';
import React from 'react';

const SPINS_COUNT = 3;

export default function CarListSpinner() {
    const CarSpinner = () => <ListItem button divider>
        <ListItemAvatar>
            <Avatar>
                <Skeleton animation="pulse" variant="circle"/>
            </Avatar>
        </ListItemAvatar>
        <ListItemText primary={
            <Typography gutterBottom variant="h5" component="h2">
                <Skeleton animation="pulse" variant="text"/>
            </Typography>
        } secondary={
            <Skeleton animation="pulse" variant="text"/>
        }/>
    </ListItem>;

    return <>
        {new Array(SPINS_COUNT).fill(true).map((_, index) => {
            return <CarSpinner key={index}/>;
        })}
    </>;
}