import {
    Button,
    Dialog,
    DialogActions,
    DialogContent,
    DialogContentText,
    DialogTitle
} from '@material-ui/core';
import React, { Dispatch } from 'react';
import { getSensorValue, ICarInfo } from './index';
import { EMPTY_DATA } from '../../constants';
import ErrorCard from '../ErrorCard';

interface ICarDialogProps {
    open: boolean,
    openModal: Dispatch<any>,
    onConfirm: Dispatch<any>,
    data: ICarInfo | null,
    title: string,
    isLoading?: boolean
    error?: Error
}

export default function CarDialog({open, openModal, data, title, onConfirm, isLoading, error}: ICarDialogProps) {
    let sensors = data?.sensors || [];

    return <Dialog
        open={open}
        onClose={openModal.bind(null, false)}
        aria-labelledby="alert-dialog-title"
        aria-describedby="alert-dialog-description">
        <DialogTitle id="alert-dialog-title">{title ?? 'Какое-то действие с машиной'}</DialogTitle>
        <DialogContent>
            <DialogContentText id="alert-dialog-description">
                <div>
                    <strong>Внимание! </strong>
                    Перед выполнением операции убедитесь, что вы действуете согласно инструцкции!
                </div>
                <div>Скорость автомобиля: <strong>{
                    getSensorValue(sensors, 'speed') !== null
                        ? `${getSensorValue(sensors, 'speed')?.toFixed(1)} км/ч`
                        : EMPTY_DATA
                }</strong></div>
                <div>Двигатель: <strong>{
                    getSensorValue(sensors, 'engine_on') !== null
                        ? getSensorValue(sensors, 'engine_on') ? 'ВКЛ' : 'ВЫКЛ'
                        : EMPTY_DATA
                }</strong></div>

            </DialogContentText>
        </DialogContent>
        {error
            ? <ErrorCard error={error}/>
            : null}
        <DialogActions>
            <Button disabled={isLoading} color="primary" variant={'outlined'} onClick={openModal.bind(null, false)}>
                Нет
            </Button>
            <Button disabled={isLoading} color="primary" variant={'outlined'} onClick={onConfirm.bind(null)}>
                Да
            </Button>
        </DialogActions>
    </Dialog>;
}