import React from 'react';
import { createStyles, makeStyles, Theme } from '@material-ui/core';

const useStyles = makeStyles((theme: Theme) =>
    createStyles({
        number: {
            display: 'block',
            backgroundColor: '#e2e2e2',
            borderRadius: theme.spacing(1),
            paddingLeft: theme.spacing(.8),
            paddingRight: theme.spacing(.8),
        },
        block: {
            paddingRight: theme.spacing(.4)
        }
    }),
);

export default function CarNumber({number}) {
    const classes = useStyles();
    let _ = (number || 'XXXXXXXXX')?.toUpperCase();
    return <div className={classes.number}>
        <span className={classes.block}>{_.substr(0, 1)}</span>
        <span className={classes.block}>{_.substr(1, 3)}</span>
        <span className={classes.block}>{_.substr(4, 2)}</span>
        <span>{_.substr(6, 3)} </span>
    </div>;
};