import React from 'react';
import { Grid, Paper, Typography } from '@material-ui/core';
import useStyles from './styles';
import { getSensorValue, ICarInfo, ISensor } from './index';

const getDoorSensors = (sensors: ISensor[]) => {
    return (key: string) => {
        let sensorValue = getSensorValue(sensors, key);
        return sensorValue !== null
            ? sensorValue ? 'Открыт' : 'Закрыто'
            : null;
    };
};

export default function Doors({data}: { data: ICarInfo | null }) {
    const mainClasses = useStyles();
    let sensors = data?.sensors || [];
    let getDoorData = getDoorSensors(sensors);

    return <Paper className={mainClasses.card}>
        <Grid item container spacing={1} xs={12} direction={'column'}>
            <DoorRow left={getDoorData('front_left_door_open')} right={getDoorData('front_right_door_open')}
                     title={'Передняя'}/>
            <DoorRow left={getDoorData('rear_left_door_open')} right={getDoorData('rear_right_door_open')}
                     title={'Задняя'}/>
            <DoorRow left={getDoorData('hood_open')} right={getDoorData('trunk_open')} leftTitle={'Капот'}
                     rightTitle={'Багажник'}/>
        </Grid>
    </Paper>;
}

const DoorRow = ({left, right, leftTitle = 'левая', rightTitle = 'правая', title = ''}) => {
    return <Grid item xs={12} container direction={'row'}>
        <Grid item xs={6} container direction={'column'}>
            <Grid item><Typography noWrap>{title} {leftTitle}</Typography></Grid>
            <Grid item><strong>{left}</strong></Grid>
        </Grid>
        <Grid item xs={6} container direction={'column'}>
            <Grid item><Typography noWrap>{title} {rightTitle}</Typography></Grid>
            <Grid item><strong>{right}</strong></Grid>
        </Grid>
    </Grid>;
};
