import {
    Button,
    createStyles,
    Grid,
    ListItem,
    ListItemText,
    makeStyles,
    Paper,
    Theme,
} from '@material-ui/core';
import { Skeleton } from '@material-ui/lab';
import React from 'react';
import { useHistory } from 'react-router-dom';
import CarNumber from './CarNumber';
import speed from '../../inline-svg/speed.svg';
import engine from '../../inline-svg/engine.svg';
import acc from '../../inline-svg/acc_level.svg';
import fuel from '../../inline-svg/fuel_level.svg';
import useStyles from './styles';
import { getSensorValue, ICarInfo } from './index';
import { EMPTY_DATA } from '../../constants';

const _useStyles = makeStyles((theme: Theme) =>
    createStyles({
        avatar: {
            width: theme.spacing(17),
            height: theme.spacing(7),
        },
        listItem: {
            padding: 0
        },
        skeleton: {
            height: 190
        }
    }),
);

interface IMainCarCardProps {
    find_text: string,
    isLoading: boolean,
    carInfo: ICarInfo | null,
}

export default function MainCarCard({find_text, isLoading, carInfo}: IMainCarCardProps) {
    const mainClasses = useStyles();
    let history = useHistory();
    let sensors = carInfo?.sensors || [];

    const back = () => {
        history.push(`/search/${find_text}`);
    };
    const classes = _useStyles();
    // let model = data?.models?.[0] || {};

    return <Paper className={mainClasses.card}>
        {isLoading
            ? <Grid item xs={12} container direction={'column'} justify={'space-around'} className={classes.skeleton}>
                <Skeleton variant={'rect'} animation={'pulse'} height={60}/>
                <Skeleton variant={'rect'} animation={'pulse'} height={40}/>
                <Skeleton variant={'rect'} animation={'pulse'} height={30}/>
            </Grid>
            : <Grid container spacing={1} direction="row">
                <Grid item container spacing={0} alignItems={'flex-start'}>
                    <ListItem className={classes.listItem}>
                        {/*<Avatar variant="rounded" className={classes.avatar} src={model.image_large_url}>*/}
                        {/*    <DirectionsCar/>*/}
                        {/*</Avatar>*/}
                        <ListItemText
                            // primary={<Typography variant="h6" noWrap>{model.name}</Typography>}
                            secondary={<Grid item container alignItems={'flex-start'}
                                             direction={'column'}
                                             spacing={0}>
                                <div><CarNumber number={carInfo?.number}/></div>
                                {/*<div>{data?.status}</div>*/}
                            </Grid>}/>
                    </ListItem>
                </Grid>
                <Grid item container direction="row" xs={12} justify={'space-around'}>
                    <Grid item xs={3} container direction="column" alignItems={'center'}>
                        <Grid item>
                            <div dangerouslySetInnerHTML={{__html: speed}} className={mainClasses.svg}/>
                        </Grid>
                        <Grid item>
                            <div>{
                                getSensorValue(sensors, 'speed') !== null
                                    ? `${getSensorValue(sensors, 'speed')?.toFixed(1)} км/ч`
                                    : EMPTY_DATA
                            }</div>
                        </Grid>
                    </Grid>
                    <Grid item xs={3} container direction="column" alignItems={'center'}>
                        <Grid item>
                            <div dangerouslySetInnerHTML={{__html: engine}} className={mainClasses.svg}/>
                        </Grid>
                        <Grid item>
                            <div>{
                                getSensorValue(sensors, 'engine_on') !== null
                                    ? getSensorValue(sensors, 'engine_on') ? 'ВКЛ' : 'ВЫКЛ'
                                    : EMPTY_DATA
                            }</div>
                        </Grid>
                    </Grid>
                    <Grid item xs={3} container direction="column" alignItems={'center'}>
                        <Grid item>
                            <div dangerouslySetInnerHTML={{__html: acc}} className={mainClasses.svg}/>
                        </Grid>
                        <Grid item>
                            <div>
                                {
                                    getSensorValue(sensors, 'acc_voltage') !== null
                                        ? getSensorValue(sensors, 'acc_voltage')?.toFixed(1)
                                        : EMPTY_DATA
                                }
                                /
                                {
                                    getSensorValue(sensors, 'ext_voltage') !== null
                                        ? getSensorValue(sensors, 'ext_voltage')?.toFixed(1)
                                        : EMPTY_DATA
                                }
                            </div>
                        </Grid>
                    </Grid>
                    <Grid item xs={3} container direction="column" justify={'center'} alignItems={'center'}>
                        <Grid item>
                            <div dangerouslySetInnerHTML={{__html: fuel}} className={mainClasses.svg}/>
                        </Grid>
                        <Grid item>
                            <div>{
                                getSensorValue(sensors, 'fuel_level') !== null
                                    ? `${getSensorValue(sensors, 'fuel_level')?.toFixed(1)}%`
                                    : EMPTY_DATA
                            }</div>
                        </Grid>
                    </Grid>
                </Grid>
                <Grid item container direction="row" xs={12} justify={'space-between'}>
                    {find_text
                        ? <Button color="default" variant={'outlined'} onClick={back}>
                            Назад
                        </Button>
                        : null}
                </Grid>
            </Grid>}
    </Paper>;
}

